/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.customengine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ebam.customengine.IEbamBaseRule;
import org.eclipse.ebam.customengine.RuleFactory;
import org.eclipse.ebam.customengine.utils.MsgReadUtils;
import org.eclipse.ebam.emf.interfaces.IAlarmTransactions;
import org.eclipse.ebam.emf.interfaces.ICEPTransaction;
import org.eclipse.ebam.emf.interfaces.ISbiDomainTransactions;
import org.eclipse.ebam.engine.interfaces.IEventProcessor;
import org.eclipse.ebam.event.EbamEvent;
import org.eclipse.ebam.event.IEbamEvent;
import org.eclipse.ebam.eventmanager.interfaces.IEbamEventManager;
import org.eclipse.ebam.messages.EbamMessage;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.Event;
import org.eclipse.ebam.model.entities.Rule;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomEngine
implements IEventProcessor {
    private static Logger logger = LoggerFactory.getLogger(CustomEngine.class);
    private AtomicReference<IEbamEventManager> eventManagerReference = new AtomicReference();
    private IEbamEventManager ebamEventManager;
    private AtomicReference<IAlarmTransactions> alarmReference = new AtomicReference();
    private IAlarmTransactions alarmTransactions;
    private AtomicReference<ISbiDomainTransactions> sbiDomainsReference = new AtomicReference();
    private ISbiDomainTransactions sbiDomainTransactions;
    private AtomicReference<ICEPTransaction> cepReference = new AtomicReference();
    private ICEPTransaction cepTransaction;
    public static final String RULE_TYPE = "RULE_TYPE";
    public static final String BASE = "BASE";
    private HashMap<String, Vector<IEbamBaseRule>> rules = null;

    protected void activate(ComponentContext componentContext) {
        try {
            this.init();
        }
        catch (Exception e) {
            logger.error("activate" + e.getMessage(), (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
    }

    public void init() {
        logger.debug("IN");
        this.alarmTransactions = this.alarmReference.get();
        this.ebamEventManager = this.eventManagerReference.get();
        this.sbiDomainTransactions = this.sbiDomainsReference.get();
        this.cepTransaction = this.cepReference.get();
        this.rules = new HashMap();
        List baseRules = new ArrayList();
        SbiDomain sbiDomain = null;
        try {
            sbiDomain = this.sbiDomainTransactions.getSbiDomainByCodeAndDomainCd(BASE, RULE_TYPE);
        }
        catch (Exception e) {
            logger.error("could not retrieve domain", (Throwable)e);
        }
        if (sbiDomain != null) {
            baseRules = this.cepTransaction.retrieveCEPRulesByType(sbiDomain);
            for (Rule rule : baseRules) {
                Vector<IEbamBaseRule> expRules;
                IEbamBaseRule eBamRule;
                String expression = rule.getExpression();
                logger.debug("expression=" + expression);
                EbamMessage tempM = new EbamMessage();
                tempM.setMsg(expression);
                String classToLoad = MsgReadUtils.extractByQuery((IEbamMessage)tempM, "//*/class", null);
                logger.info("classToLoad=" + classToLoad);
                if (classToLoad == null || (eBamRule = new RuleFactory().createRule(classToLoad)) == null) continue;
                eBamRule.init(expression);
                SbiAlarm sbiAlarm = this.retrieveRuleAlarm(rule);
                if (sbiAlarm != null) {
                    eBamRule.setSbiAlarm(sbiAlarm);
                    logger.info("Add Alarm....name=" + sbiAlarm.getName());
                }
                if ((expRules = this.rules.get(rule.getService())) == null) {
                    expRules = new Vector();
                    expRules.add(eBamRule);
                    this.rules.put(rule.getService(), expRules);
                    logger.info("Add new Rule.1");
                    continue;
                }
                expRules.add(eBamRule);
                logger.info("Add new Rule.2");
            }
        }
        logger.debug("OUT");
    }

    public void sendToEventProcessor(IEbamMessage ebamMessage) {
        logger.debug("IN. message " + ebamMessage.getMsg());
        Vector<IEbamBaseRule> rulesVector = this.rules.get(ebamMessage.getService());
        if (rulesVector != null) {
            logger.debug("rulesVector != null");
            for (IEbamBaseRule rule : rulesVector) {
                logger.debug("I'm executing rule to this message...");
                IEbamEvent ev = rule.executeRule(ebamMessage);
                if (ev == null) continue;
                logger.debug("The rule has generated a new Event, and eBAM call processEvent");
                ev.setMsg(ebamMessage);
                this.ebamEventManager.processEvent(ev);
            }
        }
        try {
            if (ebamMessage.getAlarmLabel() != null) {
                logger.debug("ebamMessage.getAlarmLabel()!=null");
                EbamEvent ev = new EbamEvent();
                ev.setType("ALARM");
                ev.setMsg(ebamMessage);
                String alarmLabel = ebamMessage.getAlarmLabel();
                SbiAlarm a = null;
                a = this.alarmTransactions.alarmTransactionloadSbiAlarmByLabel(alarmLabel);
                if (a != null) {
                    logger.debug("Exist Alarm on DB Configuration");
                    ev.setAlarm(a);
                    this.ebamEventManager.processEvent((IEbamEvent)ev);
                } else {
                    logger.debug("No Alarm on DB...");
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while loading SbiAlarm By Label" + e.getMessage());
            e.printStackTrace();
            return;
        }
        logger.debug("OUT");
    }

    protected SbiAlarm retrieveRuleAlarm(Rule rule) {
        logger.debug("IN");
        SbiAlarm alarm = null;
        Event ev = rule.getEvent();
        Double eventId = ev.getEventId();
        List listAlarm = null;
        try {
            listAlarm = this.alarmTransactions.loadSbiAlarmListByEventId(eventId);
        }
        catch (Exception e) {
            logger.error("Exception in getting alarm list", (Throwable)e);
        }
        if (listAlarm != null && !listAlarm.isEmpty()) {
            alarm = (SbiAlarm)listAlarm.iterator().next();
            logger.debug("Found 1 Alarm...");
        }
        logger.debug("OUT");
        return alarm;
    }

    public void setEbamEventManager(IEbamEventManager a) {
        this.eventManagerReference.set(a);
    }

    public void unsetEbamEventManager(IEbamEventManager a) {
        this.eventManagerReference.compareAndSet(a, null);
    }

    public String getName() {
        return BASE;
    }

    public void setAlarmTransactions(IAlarmTransactions a) {
        this.alarmReference.set(a);
    }

    public void unsetAlarmTransactions(IAlarmTransactions a) {
        this.alarmReference.compareAndSet(a, null);
    }

    public void setSbiDomainTransactions(ISbiDomainTransactions a) {
        this.sbiDomainsReference.set(a);
    }

    public void unsetSbiDomainTransactions(ISbiDomainTransactions a) {
        this.sbiDomainsReference.compareAndSet(a, null);
    }

    public void setCepTransaction(ICEPTransaction a) {
        this.cepReference.set(a);
    }

    public void unsetCepTransaction(ICEPTransaction a) {
        this.cepReference.compareAndSet(a, null);
    }
}

