/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.FunctionalConstraintsBlock;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.monitoring.generator.GeneratorUtility;
import org.eclipse.comma.monitoring.generator.TaskClassGenerator;
import org.eclipse.comma.monitoring.generator.TaskGeneratorParams;
import org.eclipse.comma.monitoring.lib.CComponentTypeDescriptor;
import org.eclipse.comma.monitoring.lib.CPartDescriptor;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.generatortasks.GeneratorTask;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.project.ComponentReference;
import org.eclipse.comma.project.project.ExecutableSource;
import org.eclipse.comma.project.project.FilePath;
import org.eclipse.comma.project.project.MonitoringTask;
import org.eclipse.comma.project.project.TraceSource;
import org.eclipse.comma.traces.events.traceEvents.Component;
import org.eclipse.comma.traces.events.traceEvents.Connection;
import org.eclipse.comma.traces.events.traceEvents.TraceEvents;
import org.eclipse.comma.traces.events.utilities.EventsUtilities;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MonitoringGeneratorTask
extends GeneratorTask {
    private static final String TEMP_CREATE_FOLDER = "temp";
    protected final MonitoringTask task;
    protected final CommaFileSystemAccess javaFileSystemAccess;
    protected final CommaFileSystemAccess convertedTracesFSA;
    private List<URI> traces = new ArrayList<URI>();
    private TaskGeneratorParams params = new TaskGeneratorParams();

    public MonitoringGeneratorTask(MonitoringTask task, IScopeProvider scopeProvider, OutputLocator outputLocator, IFileSystemAccess2 fsa) {
        super(task, scopeProvider, outputLocator, fsa);
        this.task = task;
        this.javaFileSystemAccess = this.commaFSA("java/");
        this.convertedTracesFSA = this.commaFSA("traces");
    }

    @Override
    protected void doGenerate() throws IllegalArgumentException {
        this.createStatisticsFolder();
        this.fetchTraces();
        this.params.taskName = this.task.getName();
        this.params.skipTimeConstraints = this.task.isSkipTimeConstraints() || this.task.isSkipConstraints();
        this.params.skipDataConstraints = this.task.isSkipDataConstraints() || this.task.isSkipConstraints();
        this.params.applyReordering = this.task.isApplyReordering();
        ExecutableSource _source = this.task.getSource();
        if (_source instanceof ComponentReference) {
            this.generateComponentMonitor();
        } else {
            this.generateInterfaceMonitor();
        }
    }

    public void generateInterfaceMonitor() {
        Interface interface_ = this.getInterface(this.task.getSource());
        boolean _isEmpty = this.traces.isEmpty();
        if (_isEmpty) {
            String _name = this.task.getName();
            String _plus = "Warning: no valid traces were located for monitoring task " + _name;
            this.errors.add(_plus);
        }
        this.params.taskKind = "interface";
        this.params.interface_ = interface_;
        for (URI traceUri : this.traces) {
            try {
                TraceEvents eventsModel;
                String traceFileName = traceUri.trimFileExtension().lastSegment();
                String tracePath = this.getTracePath(traceUri);
                boolean _equals = traceUri.fileExtension().equals("events");
                if (_equals && (eventsModel = EventsUtilities.readHeader((URI)traceUri)) == null) {
                    throw this.createException("Monitoring Task: File did not contain the Events syntax " + traceUri + "\n", this.resource, MonitoringGeneratorTask.class);
                }
                this.params.traceFileNames.add(traceFileName);
                this.params.traceFilePaths.add(tracePath);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception exception = (Exception)_t;
                    String _message = exception.getMessage();
                    String _plus_1 = "Trace could not be read: " + traceUri + ".  " + _message;
                    this.errors.add(_plus_1);
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        new TaskClassGenerator((IFileSystemAccess)this.javaFileSystemAccess, this.params).generateTask();
    }

    public void generateComponentMonitor() {
        ExecutableSource _source = this.task.getSource();
        org.eclipse.comma.behavior.component.component.Component component = ((ComponentReference)_source).getComponent();
        final List visibleInterfaces = ComponentUtilities.getAllInterfaces((EObject)this.task, (IScopeProvider)this.scopeProvider);
        this.params.taskKind = "component";
        this.params.component = component;
        List allComponents = ComponentUtilities.getAllComponents((EObject)this.task, (IScopeProvider)this.scopeProvider);
        for (org.eclipse.comma.behavior.component.component.Component c : allComponents) {
            CComponentTypeDescriptor td = new CComponentTypeDescriptor();
            td.componentType = CommaUtilities.getFullyQualifiedNameAsString((NamedElement)c);
            Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

                public Boolean apply(Port it) {
                    return it instanceof ProvidedPort;
                }
            };
            Functions.Function1<Port, Boolean> _function_1 = new Functions.Function1<Port, Boolean>(){

                public Boolean apply(final Port p) {
                    Functions.Function1<Interface, Boolean> _function = new Functions.Function1<Interface, Boolean>(){

                        public Boolean apply(Interface i) {
                            return CommaUtilities.getFullyQualifiedNameAsString((NamedElement)i).equals(CommaUtilities.getFullyQualifiedNameAsString((NamedElement)p.getInterface())) && i.isSingleton();
                        }
                    };
                    return IterableExtensions.exists((Iterable)visibleInterfaces, (Functions.Function1)_function);
                }
            };
            Functions.Function1<Port, String> _function_2 = new Functions.Function1<Port, String>(){

                public String apply(Port it) {
                    return it.getName();
                }
            };
            td.singletonPorts = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)c.getPorts(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
            boolean _equals = Objects.equal((Object)c, (Object)component);
            if (_equals) {
                td.partDescriptors = GeneratorUtility.getPartDescriptors((org.eclipse.comma.behavior.component.component.Component)c);
            }
            this.params.componentDescriptors.add(td);
        }
        List<URI> validTraces = this.generateComponentResultsStructure(component, this.params);
        boolean _isEmpty = validTraces.isEmpty();
        if (_isEmpty) {
            String _name = this.task.getName();
            String _plus = "Warning: no valid traces were located for monitoring task " + _name;
            this.errors.add(_plus);
        }
        new TaskClassGenerator((IFileSystemAccess)this.javaFileSystemAccess, this.params).generateTask();
    }

    public List<URI> generateComponentResultsStructure(final org.eclipse.comma.behavior.component.component.Component component, TaskGeneratorParams params) {
        ArrayList<URI> validTraces = new ArrayList<URI>();
        List allComponents = ComponentUtilities.getAllComponents((EObject)this.task, (IScopeProvider)this.scopeProvider);
        List partDescriptors = GeneratorUtility.getPartDescriptors((org.eclipse.comma.behavior.component.component.Component)component);
        for (URI traceUri : this.traces) {
            try {
                String traceFileName = traceUri.trimFileExtension().lastSegment();
                String traceFile = this.getTracePath(traceUri);
                TraceEvents _xifexpression = null;
                boolean _equals = traceUri.fileExtension().toString().equals("jsonl");
                _xifexpression = _equals ? EventsUtilities.readHeaderFromJson((URI)traceUri) : EventsUtilities.readHeader((URI)traceUri);
                TraceEvents eventsModel = _xifexpression;
                if (eventsModel == null) {
                    throw this.createException("Monitoring Task: File did not contain the Events syntax " + traceUri + "\n", this.resource, MonitoringGeneratorTask.class);
                }
                Functions.Function1<Component, Boolean> _function = new Functions.Function1<Component, Boolean>(){

                    public Boolean apply(Component it) {
                        return it.getComponentType().equals(CommaUtilities.getFullyQualifiedNameAsString((NamedElement)component));
                    }
                };
                Iterable componentInstances = IterableExtensions.filter((Iterable)eventsModel.getComponents(), (Functions.Function1)_function);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)componentInstances);
                if (_isEmpty) {
                    String _fullyQualifiedNameAsString = CommaUtilities.getFullyQualifiedNameAsString((NamedElement)component);
                    String _plus = "Warning: trace file " + traceUri + " does not contain component instances of type " + _fullyQualifiedNameAsString;
                    String _plus_1 = String.valueOf(_plus) + "\n";
                    throw this.createException(_plus_1, this.resource, MonitoringGeneratorTask.class);
                }
                for (Component componentInstance : componentInstances) {
                    FunctionalConstraint fc2;
                    boolean _tripleNotEquals;
                    FunctionalConstraintsBlock _functionalConstraintsBlock = component.getFunctionalConstraintsBlock();
                    boolean bl = _tripleNotEquals = _functionalConstraintsBlock != null;
                    if (_tripleNotEquals) {
                        EList _functionalConstraints = component.getFunctionalConstraintsBlock().getFunctionalConstraints();
                        for (FunctionalConstraint fc2 : _functionalConstraints) {
                            this.createMonitorResultsFolder(this.componentFuncConstraintResultsFolder(traceFileName, componentInstance.getComponentId(), fc2.getName()));
                        }
                    }
                    this.createMonitorResultsFolder(this.componentTimeDataResultsFolder(traceFileName, componentInstance.getComponentId()));
                    fc2 = partDescriptors.iterator();
                    while (fc2.hasNext()) {
                        final CPartDescriptor part = (CPartDescriptor)fc2.next();
                        Functions.Function1<org.eclipse.comma.behavior.component.component.Component, Boolean> _function_1 = new Functions.Function1<org.eclipse.comma.behavior.component.component.Component, Boolean>(){

                            public Boolean apply(org.eclipse.comma.behavior.component.component.Component it) {
                                return it.getName().equals(part.type);
                            }
                        };
                        FunctionalConstraintsBlock fcBlock = ((org.eclipse.comma.behavior.component.component.Component)IterableExtensions.findFirst((Iterable)allComponents, (Functions.Function1)_function_1)).getFunctionalConstraintsBlock();
                        if (fcBlock != null) {
                            EList _functionalConstraints_1 = fcBlock.getFunctionalConstraints();
                            for (FunctionalConstraint fc_1 : _functionalConstraints_1) {
                                String _componentId = componentInstance.getComponentId();
                                String _plus_2 = String.valueOf(_componentId) + part.partId;
                                this.createMonitorResultsFolder(this.componentFuncConstraintResultsFolder(traceFileName, _plus_2, fc_1.getName()));
                            }
                        }
                        String _componentId_1 = componentInstance.getComponentId();
                        String _plus_3 = String.valueOf(_componentId_1) + part.partId;
                        this.createMonitorResultsFolder(this.componentTimeDataResultsFolder(traceFileName, _plus_3));
                    }
                }
                params.traceFileNames.add(traceFileName);
                params.traceFilePaths.add(traceFile);
                Functions.Function1<Component, String> _function_1 = new Functions.Function1<Component, String>(){

                    public String apply(Component it) {
                        return it.getComponentId();
                    }
                };
                params.componentInstances.add(IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)componentInstances, (Functions.Function1)_function_1)));
                HashMap<String, org.eclipse.comma.behavior.component.component.Component> allInstances = new HashMap<String, org.eclipse.comma.behavior.component.component.Component>();
                EList _components = eventsModel.getComponents();
                for (final Component c : _components) {
                    Functions.Function1<org.eclipse.comma.behavior.component.component.Component, Boolean> _function_2 = new Functions.Function1<org.eclipse.comma.behavior.component.component.Component, Boolean>(){

                        public Boolean apply(org.eclipse.comma.behavior.component.component.Component it) {
                            return it.getName().equals(c.getComponentType());
                        }
                    };
                    allInstances.put(c.getComponentId(), (org.eclipse.comma.behavior.component.component.Component)IterableExtensions.findFirst((Iterable)allComponents, (Functions.Function1)_function_2));
                }
                params.allInstances.add(allInstances);
                validTraces.add(traceUri);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception exception = (Exception)_t;
                    this.errors.add(exception.getMessage());
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return validTraces;
    }

    public Boolean fetchTraces() {
        boolean _not;
        boolean _xifexpression = false;
        boolean _isEmpty = this.task.getTraces().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1<FilePath, Boolean> _function = new Functions.Function1<FilePath, Boolean>(){

                public Boolean apply(FilePath p) {
                    String _path = p.getPath();
                    return _path != null;
                }
            };
            List fileSources = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(this.task.getTraces(), FilePath.class), (Functions.Function1)_function));
            Functions.Function1<TraceSource, Boolean> _function_1 = new Functions.Function1<TraceSource, Boolean>(){

                public Boolean apply(TraceSource ts) {
                    return !(ts instanceof FilePath);
                }
            };
            Iterable taskSources = IterableExtensions.filter(this.task.getTraces(), (Functions.Function1)_function_1);
            ProjectUtility.TraceResources resources = ProjectUtility.getTraceResourcesFromFiles(fileSources);
            for (URI traceUri : resources.validURIs) {
                this.addTrace(traceUri);
            }
            for (TraceSource traceSource : taskSources) {
                this.addTrace(this.getTraceResourceURI(traceSource));
            }
            for (FilePath invalid : resources.invalidTraceSources) {
                String _path = invalid.getPath();
                String _plus = "Invalid resource " + _path;
                String _plus_1 = String.valueOf(_plus) + ". Will be ignored.";
                this.errors.add(_plus_1);
            }
            for (FilePath wrongNamed : resources.wrongnamedTraceSources) {
                String _path_1 = wrongNamed.getPath();
                String _plus_2 = "Trace file name must start with a letter and may contain letters, digits and _. Resource " + _path_1;
                String _plus_3 = String.valueOf(_plus_2) + " will be ignored.";
                this.errors.add(_plus_3);
            }
            for (FilePath duplicate : resources.duplicateTraceSources) {
                String _path_2 = duplicate.getPath();
                String _plus_4 = "Resource with name " + _path_2;
                String _plus_5 = String.valueOf(_plus_4) + " is duplicated. Will be ignored.";
                this.errors.add(_plus_5);
            }
        } else {
            boolean _not_2;
            boolean _not_1;
            boolean _xblockexpression = false;
            ProjectUtility.TraceResources resources_1 = ProjectUtility.getTraceResourcesFromDirs(this.task.getTracedirs());
            for (URI trace : resources_1.validURIs) {
                this.addTrace(trace);
            }
            for (FilePath dir : resources_1.nonexistentDirectories) {
                String _path_3 = dir.getPath();
                String _plus_6 = "Directory " + _path_3;
                String _plus_7 = String.valueOf(_plus_6) + " does not exist.";
                this.errors.add(_plus_7);
            }
            for (FilePath dir_1 : resources_1.duplicateDirectories) {
                String _path_4 = dir_1.getPath();
                String _plus_8 = "Directory with name " + _path_4;
                String _plus_9 = String.valueOf(_plus_8) + " is duplicated.";
                this.errors.add(_plus_9);
            }
            boolean _isEmpty_1 = resources_1.duplicateTraceFiles.isEmpty();
            boolean bl2 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                this.errors.add("Trace directories contain files with duplicated names. Only the first occurrence will be used");
            }
            boolean _xifexpression_1 = false;
            boolean _isEmpty_2 = resources_1.wrongnamedTraceFiles.isEmpty();
            boolean bl3 = _not_2 = !_isEmpty_2;
            if (_not_2) {
                _xifexpression_1 = this.errors.add("Trace directories contain files with names that contain '-' or white space. Files will be ignored.");
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public void createStatisticsFolder() {
        CommaFileSystemAccess statsFSA = CommaFileSystemAccess.getStatisticsFSA((IFileSystemAccess2)this.fsa, (String)this.task.getName());
        statsFSA.generateFile(TEMP_CREATE_FOLDER, (CharSequence)"");
        statsFSA.deleteFile(TEMP_CREATE_FOLDER);
    }

    public void createMonitorResultsFolder(String folderPath) {
        CommaFileSystemAccess monitorFSA = CommaFileSystemAccess.getMonitorResultFSA((IFileSystemAccess2)this.fsa, (String)this.task.getName(), (String)folderPath);
        monitorFSA.generateFile(TEMP_CREATE_FOLDER, (CharSequence)"");
        monitorFSA.deleteFile(TEMP_CREATE_FOLDER);
    }

    public boolean addTrace(URI traceUri) {
        boolean _xblockexpression = false;
        String fileExtension = traceUri.fileExtension();
        boolean _xifexpression = false;
        if (fileExtension.equals("events") || fileExtension.equals("jsonl")) {
            _xifexpression = this.traces.add(traceUri);
        } else {
            boolean _xifexpression_1 = false;
            boolean _equals = fileExtension.equals("traces");
            if (!_equals) {
                throw this.createException("Monitoring Task: File did not contain the Traces syntax " + traceUri + "\n", this.resource, MonitoringGeneratorTask.class);
            }
            String _plus = traceUri + " file format is not supported.";
            _xifexpression_1 = this.errors.add(_plus);
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getTracePath(URI traceUri) {
        IFileSystemAccess2 _iFileSystemAccess;
        String _xblockexpression = null;
        IFileSystemAccess2 fs = _iFileSystemAccess = this.commaFSA("../").getIFileSystemAccess();
        URI playerUri = fs.getURI("../f.java");
        URI uri = traceUri.deresolve(playerUri, true, true, true);
        _xblockexpression = uri.toFileString().replace("\\", "\\\\");
        return _xblockexpression;
    }

    public Iterable<Connection> connections(TraceEvents trace, final Interface i) {
        Collection _xblockexpression = null;
        Functions.Function1<Connection, Boolean> _function = new Functions.Function1<Connection, Boolean>(){

            public Boolean apply(Connection it) {
                return it.getInterface().equals(CommaUtilities.getFullyQualifiedNameAsString((NamedElement)i));
            }
        };
        Collection connections = IterableExtensions.filter((Iterable)trace.getConnections(), (Functions.Function1)_function);
        boolean _isSingleton = i.isSingleton();
        if (_isSingleton) {
            final HashMap endPoints = new HashMap();
            Consumer<Connection> _function_1 = new Consumer<Connection>(){

                @Override
                public void accept(Connection it) {
                    String _target = it.getTarget();
                    String _targetPort = it.getTargetPort();
                    String _plus = String.valueOf(_target) + _targetPort;
                    endPoints.put(_plus, it);
                }
            };
            connections.forEach(_function_1);
            connections = endPoints.values();
        }
        _xblockexpression = connections;
        return _xblockexpression;
    }

    public CharSequence reportFilePrefix(Connection c, Interface i) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isSingleton = i.isSingleton();
        if (_isSingleton) {
            String _target = c.getTarget();
            _builder.append(_target);
            _builder.append("_");
            String _targetPort = c.getTargetPort();
            _builder.append(_targetPort);
            _builder.append("_");
            String _fullyQualifiedNameAsString = CommaUtilities.getFullyQualifiedNameAsString((NamedElement)i);
            _builder.append(_fullyQualifiedNameAsString);
        } else {
            String _target_1 = c.getTarget();
            _builder.append(_target_1);
            _builder.append("_");
            String _source = c.getSource();
            _builder.append(_source);
            _builder.append("_");
            String _fullyQualifiedNameAsString_1 = CommaUtilities.getFullyQualifiedNameAsString((NamedElement)i);
            _builder.append(_fullyQualifiedNameAsString_1);
        }
        return _builder;
    }

    public CharSequence interfaceOutLocalPath(String traceFileName, Connection c, Interface i) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(traceFileName);
        _builder.append("/");
        CharSequence _reportFilePrefix = this.reportFilePrefix(c, i);
        _builder.append((Object)_reportFilePrefix);
        _builder.append("/");
        return _builder;
    }

    public String componentFuncConstraintResultsFolder(String traceFileName, String componentId, String fcName) {
        return String.valueOf(traceFileName) + "/" + componentId + "/" + fcName;
    }

    public String componentTimeDataResultsFolder(String traceFileName, String componentId) {
        return String.valueOf(traceFileName) + "/" + componentId + "/time_data";
    }

    public CharSequence portOutLocalPath(String traceFileName, String componentInstance, String portName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(traceFileName);
        _builder.append("/");
        _builder.append(componentInstance);
        _builder.append("/port_");
        _builder.append(portName);
        _builder.append("/");
        return _builder;
    }
}

