/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
/**
 * Implements an exponential backoff, which increases the delay between requests
 * when a request failure occurs, and resets the delay on success.
 */
export declare class ExponentialBackoffUtil {
    static getDefaultBackoffUtil(maxFailureDelay: number): ExponentialBackoffUtil;
    private readonly _minFailureDelay;
    private _failureDelay;
    private readonly _maxFailureDelay;
    private readonly _backoffExponent;
    constructor(minFailureDelay: number, maxFailureDelay: number, backoffExponent: number);
    sleepAsync(): Promise<void>;
    failIncrease(): void;
    successReset(): void;
}
