/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.net.URL;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenTektonDashboardAction
extends SelectionProviderAction {
    protected CodewindApplication app;

    public OpenTektonDashboardAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.ActionOpenTektonDashboard);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            this.setEnabled(this.app.isAvailable());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"OpenTektonDashboardAction ran but no application was selected");
            return;
        }
        URL url = this.app.connection.getTektonDashboardURL();
        if (url == null) {
            Logger.logError((String)"OpenTektonDashboardAction ran but could not get the url");
            return;
        }
        try {
            IWebBrowser browser = null;
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            if (CoreUtil.isWindows()) {
                browser = browserSupport.getExternalBrowser();
            }
            if (browser == null) {
                browser = browserSupport.createBrowser(6, this.app.projectID + "_tektonDashboard", this.app.name, NLS.bind((String)Messages.BrowserTooltipTektonDashboard, (Object)this.app.name));
            }
            browser.openURL(url);
        }
        catch (PartInitException e) {
            Logger.logError((String)"Error opening the Tekton dashboard in browser", (Throwable)e);
        }
    }

    public boolean showAction() {
        return this.app != null && this.app.connection.getTektonDashboardURL() != null;
    }
}

