/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.console;

import java.io.IOException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindSocket;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class SocketConsole
extends IOConsole {
    public final CodewindApplication app;
    public final ProjectLogInfo logInfo;
    private final CodewindSocket socket;
    private IOConsoleOutputStream outputStream;
    private boolean isInitialized = false;
    private boolean showOnUpdate = false;

    public SocketConsole(String consoleName, ProjectLogInfo logInfo, CodewindApplication app) {
        super(consoleName, "codewind-console", CodewindCorePlugin.getIcon("icons/codewind.png"), true);
        this.app = app;
        this.logInfo = logInfo;
        this.outputStream = this.newOutputStream();
        this.socket = app.connection.getSocket();
        this.socket.registerSocketConsole(this);
        try {
            this.outputStream.write(Messages.LogFileInitialMsg);
            app.connection.requestEnableLogStream(app, logInfo);
        }
        catch (IOException e) {
            Logger.logError("Error opening console output stream for: " + this.getName(), e);
        }
    }

    public void update(String contents, boolean reset) throws IOException {
        if (!this.isInitialized || reset) {
            this.clearConsole();
            this.isInitialized = true;
        }
        Logger.log("Appending contents to log: " + this.getName());
        this.outputStream.write(contents);
        if (this.showOnUpdate) {
            this.activate();
        }
    }

    protected void dispose() {
        Logger.log("Dispose console " + this.getName());
        this.socket.deregisterSocketConsole(this);
        try {
            this.app.connection.requestDisableLogStream(this.app, this.logInfo);
            this.outputStream.close();
        }
        catch (IOException e) {
            Logger.logError("Error closing console output stream for: " + this.getName(), e);
        }
        super.dispose();
    }

    public void setShowOnUpdate(boolean value) {
        this.showOnUpdate = value;
    }
}

