/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;

public class ValidateAction
extends SelectionProviderAction {
    CodewindApplication app;

    public ValidateAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.ValidateLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            if (this.app.isAvailable()) {
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"ValidateAction ran but no application was selected");
            return;
        }
        try {
            this.app.connection.requestValidate(this.app);
        }
        catch (Exception e) {
            Logger.logError((String)("Error requesting validation for application: " + this.app.name), (Throwable)e);
        }
    }

    public boolean showAction() {
        return this.app != null && !this.app.isAutoBuild();
    }
}

