/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.console.CodewindConsoleFactory;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.console.SocketConsole;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class ShowAllLogsAction
extends Action {
    protected CodewindEclipseApplication app;

    public ShowAllLogsAction() {
        super(Messages.ShowAllLogFilesAction);
    }

    public void setApp(CodewindEclipseApplication app) {
        this.app = app;
        boolean enabled = false;
        if (app.getLogInfos() != null && !app.getLogInfos().isEmpty()) {
            for (ProjectLogInfo logInfo : app.getLogInfos()) {
                if (app.getConsole(logInfo) != null) continue;
                enabled = true;
                break;
            }
        }
        this.setEnabled(enabled);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"ShowAllLogsAction ran but no application was selected");
            return;
        }
        if (this.app.getLogInfos() == null || this.app.getLogInfos().isEmpty()) {
            Logger.logError((String)("ShowAllLogsAction ran but there are no logs for the selected application: " + this.app.name));
            return;
        }
        for (ProjectLogInfo logInfo : this.app.getLogInfos()) {
            if (this.app.getConsole(logInfo) != null) continue;
            SocketConsole console = CodewindConsoleFactory.createLogFileConsole((CodewindApplication)this.app, (ProjectLogInfo)logInfo);
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
            this.app.addConsole(console);
        }
    }
}

