/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.ui.internal.actions.AttachDebuggerAction;
import org.eclipse.codewind.ui.internal.actions.ContainerShellAction;
import org.eclipse.codewind.ui.internal.actions.EnableDisableAutoBuildAction;
import org.eclipse.codewind.ui.internal.actions.EnableDisableInjectMetricsAction;
import org.eclipse.codewind.ui.internal.actions.EnableDisableProjectAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppMonitorAction;
import org.eclipse.codewind.ui.internal.actions.OpenPerfMonitorAction;
import org.eclipse.codewind.ui.internal.actions.RestartDebugModeAction;
import org.eclipse.codewind.ui.internal.actions.RestartRunModeAction;
import org.eclipse.codewind.ui.internal.actions.UnbindProjectAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class CodewindApplicationActionProvider
extends CommonActionProvider {
    private ISelectionProvider selProvider;
    private RestartRunModeAction restartRunAction;
    private RestartDebugModeAction restartDebugAction;
    private AttachDebuggerAction attachDebuggerAction;
    private OpenAppMonitorAction openAppMonitorAction;
    private OpenPerfMonitorAction openPerfMonitorAction;
    private ContainerShellAction containerShellAction;
    private EnableDisableAutoBuildAction enableDisableAutoBuildAction;
    private EnableDisableInjectMetricsAction enableDisableInjectMetricsAction;
    private EnableDisableProjectAction enableDisableProjectAction;
    private UnbindProjectAction unbindProjectAction;
    private OpenAppDoubleClickAction openAppDoubleClickAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.selProvider = aSite.getStructuredViewer();
        this.restartRunAction = new RestartRunModeAction(this.selProvider);
        this.restartDebugAction = new RestartDebugModeAction(this.selProvider);
        this.attachDebuggerAction = new AttachDebuggerAction(this.selProvider);
        this.openAppMonitorAction = new OpenAppMonitorAction(this.selProvider);
        this.openPerfMonitorAction = new OpenPerfMonitorAction(this.selProvider);
        this.containerShellAction = new ContainerShellAction(this.selProvider);
        this.enableDisableAutoBuildAction = new EnableDisableAutoBuildAction(this.selProvider);
        this.enableDisableInjectMetricsAction = new EnableDisableInjectMetricsAction(this.selProvider);
        this.enableDisableProjectAction = new EnableDisableProjectAction(this.selProvider);
        this.unbindProjectAction = new UnbindProjectAction(this.selProvider);
        this.openAppDoubleClickAction = new OpenAppDoubleClickAction(this.selProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        this.selProvider.setSelection(this.selProvider.getSelection());
        if (this.restartRunAction.showAction()) {
            menu.appendToGroup("group.generate", (IAction)this.restartRunAction);
        }
        if (this.restartDebugAction.showAction()) {
            menu.appendToGroup("group.generate", (IAction)this.restartDebugAction);
        }
        if (this.attachDebuggerAction.showAction()) {
            menu.appendToGroup("group.generate", (IAction)this.attachDebuggerAction);
        }
        if (this.openAppMonitorAction.showAction()) {
            menu.appendToGroup("group.open", (IAction)this.openAppMonitorAction);
        }
        if (this.openPerfMonitorAction.showAction()) {
            menu.appendToGroup("group.open", (IAction)this.openPerfMonitorAction);
        }
        if (this.containerShellAction.showAction()) {
            menu.appendToGroup("group.open", (IAction)this.containerShellAction);
        }
        menu.appendToGroup("group.build", (IAction)this.enableDisableAutoBuildAction);
        if (this.enableDisableInjectMetricsAction.showAction()) {
            menu.appendToGroup("group.build", (IAction)this.enableDisableInjectMetricsAction);
        }
        menu.appendToGroup("additions", (IAction)this.enableDisableProjectAction);
        menu.appendToGroup("additions", (IAction)this.unbindProjectAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAppDoubleClickAction);
    }

    private static class OpenAppDoubleClickAction
    extends SelectionProviderAction {
        private final OpenAppAction actionDelegate = new OpenAppAction();

        public OpenAppDoubleClickAction(ISelectionProvider selectionProvider) {
            super(selectionProvider, "");
            this.selectionChanged(this.getStructuredSelection());
        }

        public void selectionChanged(IStructuredSelection sel) {
            this.actionDelegate.selectionChanged((IAction)this, (ISelection)sel);
        }

        public void run() {
            this.actionDelegate.run((IAction)this);
        }
    }
}

