/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.util.HashMap;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.ui.actions.SelectionProviderAction;

public class ContainerShellAction
extends SelectionProviderAction {
    private static final String LAUNCHER_DELEGATE_ID = "org.eclipse.tm.terminal.connector.local.launcher.local";
    protected CodewindApplication app;

    public ContainerShellAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.ActionOpenContainerShell);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            this.setEnabled(this.app.isAvailable() && this.app.getContainerId() != null);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"ContainerShellAction ran but no application was selected");
            return;
        }
        if (this.app.getContainerId() == null) {
            Logger.logError((String)("ContainerShellAction ran but the container id for the application is not set: " + this.app.name));
            return;
        }
        String command = "sh -c \"if type bash > /dev/null; then bash; else sh; fi\"";
        String envPath = CoreUtil.getEnvPath();
        String dockerPath = envPath != null ? envPath + "docker" : "docker";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("delegateId", LAUNCHER_DELEGATE_ID);
        properties.put("secondaryId", this.app.name);
        properties.put("title", this.app.name);
        properties.put("process.path", dockerPath);
        properties.put("process.args", "exec -it " + this.app.getContainerId() + " " + command);
        ITerminalService terminal = TerminalServiceFactory.getService();
        if (terminal == null) {
            Logger.logError((String)"ContainerShellAction ran but the terminal service is null");
            return;
        }
        terminal.openConsole(properties, null);
    }

    public boolean showAction() {
        return this.app != null && this.app.connection.isLocal();
    }
}

