/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.IValue;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.model.RuleFactory;
import org.eclipse.bpel.validator.model.Validator;
import org.eclipse.bpel.validator.rules.CValidator;

public class FromValidator
extends CValidator {
    static QName[] ENDPOINT_REFRENCE = new QName[]{AT_MY_ROLE, AT_PARTNER_ROLE};
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_VARIABLE, ND_COPY);
    protected INode fVariableNode;
    protected INode fQueryNode;
    protected INode fLiteralNode;
    protected INode fPartnerLinkNode;
    protected INode fPartNode;
    protected INode fPropertyNode;
    protected String fEndpointReference;
    protected Validator fExprValidator;
    protected String fExpressionLanguage;
    protected String fPropertyName;
    protected String fPartName;
    protected String fHeaderName;

    @Override
    protected void start() {
        super.start();
        this.fVariableNode = this.mModelQuery.lookup(this.mNode, 1, this.mNode.getAttribute(AT_VARIABLE));
        this.fPartName = this.mNode.getAttribute(AT_PART);
        this.fHeaderName = this.mNode.getAttribute(AT_HEADER);
        this.fQueryNode = this.mNode.getNode(ND_QUERY);
        this.fPartnerLinkNode = this.mModelQuery.lookup(this.mNode, 2, this.mNode.getAttribute(AT_PARTNER_LINK));
        this.fEndpointReference = this.mNode.getAttribute(AT_ENDPOINT_REFERENCE);
        this.fPropertyName = this.mNode.getAttribute(AT_PROPERTY);
        this.fExpressionLanguage = this.getLanguage(this.mNode, AT_EXPRESSIONLANGUAGE);
        this.fLiteralNode = this.mNode.getNode(ND_LITERAL);
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Checks the allowed formats of the <from> element", date="01/15/2007", sa=32, errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE,BPELC_FROM__VARIANT", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckFromVariant_10() {
        int variant = 0;
        if (this.fLiteralNode != null) {
            ++variant;
        }
        if (!FromValidator.isEmpty(this.fHeaderName)) {
            this.setValue("header", this.fHeaderName);
        }
        if (this.fVariableNode != null) {
            ++variant;
            if (!this.checkValidator(this.mNode, this.fVariableNode, AT_VARIABLE, 0) || !this.checkAttributeNode(this.mNode, this.fVariableNode, AT_VARIABLE, 0)) {
                this.disableRules();
            }
        }
        if (this.fPartnerLinkNode != null) {
            ++variant;
            if (!this.checkValidator(this.mNode, this.fPartnerLinkNode, AT_PARTNER_LINK, 0) || !this.checkAttributeNode(this.mNode, this.fPartnerLinkNode, AT_PARTNER_LINK, 0)) {
                this.disableRules();
            }
            this.fEndpointReference = this.getAttribute(this.mNode, AT_ENDPOINT_REFERENCE, 0, Filters.ENDPOINT_FILTER, true);
            if (FromValidator.isEmpty(this.fEndpointReference)) {
                this.disableRules();
            }
        }
        if (variant == 0) {
            ++variant;
        }
        if (variant == 0) {
            IProblem problem = this.createError();
            problem.fill("BPELC_FROM__VARIANT", this.toString(this.mNode.nodeName()), variant);
            this.disableRules();
        } else if (variant > 1) {
            IProblem problem = this.createError();
            problem.fill("BPELC_FROM__VARIANT", this.toString(this.mNode.nodeName()), variant);
            this.disableRules();
        }
    }

    @ARule(desc="Variables used in <from> must not have part set if they are schema types.  (part must not be set) ", author="michal.chmielewski@oracle.com", date="01/15/2007", sa=34, errors="BPELC_FROM__VARIABLE_PART,BPELC__PA_NO_PART")
    public void rule_CheckVariableVariant_18() {
        if (this.isUndefined(this.fVariableNode) || this.isDefined(this.fPropertyNode)) {
            return;
        }
        INode varTypeNode = this.getValue(this.fVariableNode, "type", null);
        if (this.isUndefined(varTypeNode)) {
            return;
        }
        this.setValue("type", varTypeNode);
        if (!WSDL_ND_MESSAGE.equals(varTypeNode.nodeName())) {
            if (!FromValidator.isEmpty(this.fPartName)) {
                IProblem problem = this.createError();
                problem.fill("BPELC_FROM__VARIABLE_PART", this.toString(this.mNode.nodeName()), AT_VARIABLE, this.fVariableNode.getAttribute(AT_NAME));
            }
        } else if (!FromValidator.isEmpty(this.fPartName)) {
            INode partNode = this.mModelQuery.lookup(varTypeNode, 13, this.fPartName);
            if (this.isUndefined(partNode)) {
                IProblem problem = this.createError();
                problem.fill("BPELC__PA_NO_PART", this.toString(this.mNode.nodeName()), this.fPartName, varTypeNode);
                return;
            }
            INode partType = this.mModelQuery.lookup(partNode, 16, this.fPartName);
            if (this.isDefined(partType)) {
                this.setValue("type", partType);
            }
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="A partner link referenced in a <from> spec with endpoint  reference of 'myRole' must have myRole set.", date="01/10/2007", sa=35, errors="BPELC_FROM__PARTNER_LINK")
    public void rule_CheckPartnerLinkVariantMyRole_21() {
        if (this.isUndefined(this.fPartnerLinkNode)) {
            return;
        }
        if (AT_MY_ROLE.equals(this.fEndpointReference)) {
            String myRole = this.fPartnerLinkNode.getAttribute(AT_MY_ROLE);
            if (FromValidator.isEmptyOrWhitespace(myRole)) {
                IProblem problem = this.createError();
                problem.fill("BPELC_FROM__PARTNER_LINK", this.toString(this.mNode.nodeName()), this.fPartnerLinkNode.getAttribute(AT_NAME), this.fEndpointReference);
            } else {
                INode portType = this.getValue(this.fPartnerLinkNode, "role.portType." + myRole, null);
                this.setValue("type", portType);
            }
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="A partner link referenced in a <from> spec with endpoint  reference of 'partnerRole' must have partnerRole set.", date="01/10/2007", sa=36, errors="BPELC_FROM__PARTNER_LINK")
    public void rule_CheckPartnerLinkVariantPartnerRole_22() {
        if (this.isUndefined(this.fPartnerLinkNode)) {
            return;
        }
        if (AT_PARTNER_ROLE.equals(this.fEndpointReference)) {
            String partnerRole = this.fPartnerLinkNode.getAttribute(AT_PARTNER_ROLE);
            if (FromValidator.isEmptyOrWhitespace(partnerRole)) {
                IProblem problem = this.createError();
                problem.fill("BPELC_FROM__PARTNER_LINK", this.toString(this.mNode.nodeName()), this.fPartnerLinkNode.getAttribute(AT_NAME), this.fEndpointReference);
            } else {
                INode portType = this.getValue(this.fPartnerLinkNode, "role.portType." + partnerRole, null);
                this.setValue("type", portType);
            }
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="The literal <from> spec must return a EII or a TII only", date="01/10/2007", sa=38, errors="BPELC_FROM__LITERAL")
    public void rule_CheckLiteralVariant_30() {
        if (this.isUndefined(this.fLiteralNode)) {
            return;
        }
        List<INode> children = this.fLiteralNode.children();
        if (children.size() > 1) {
            IProblem problem = this.createError();
            problem.fill("BPELC_FROM__LITERAL", this.toString(this.mNode.nodeName()), this.fLiteralNode.nodeName(), children.size());
        }
        if (children.size() > 0) {
            children.get(0);
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Checks the actual expression using the expression language validator.", date="10/2/2006", sa=1000, warnings="BPELC__NO_EXPRESSION_VALIDATOR")
    public void rule_CheckExpressionVariant_50() {
        if (this.fVariableNode != null || this.fPropertyNode != null || this.fPartnerLinkNode != null || this.fPartName != null || this.fLiteralNode != null || this.fQueryNode != null) {
            return;
        }
        if (this.fExprValidator == null) {
            QName qname = new QName(this.fExpressionLanguage, this.mNode.nodeName().getLocalPart());
            this.fExprValidator = RuleFactory.INSTANCE.createValidator(qname);
            if (this.fExprValidator == null) {
                IProblem problem = this.createWarning();
                problem.fill("BPELC__NO_EXPRESSION_VALIDATOR", this.toString(this.mNode.nodeName()), this.fExpressionLanguage);
                return;
            }
            this.attach(this.fExprValidator);
        }
        this.setValue("type", new IValue<Object>(){

            @Override
            public Object get() {
                return FromValidator.this.fExprValidator.getValue("expression.type");
            }
        });
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Query variant checking.", date="07/07/2007", sa=1000)
    public void rule_CheckQueryVariant_55() {
        if (this.fQueryNode == null) {
            return;
        }
    }
}

