/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.extension.model.impl;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.bpel.common.extension.model.Extension;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.common.extension.model.ExtensionmodelFactory;
import org.eclipse.bpel.common.extension.model.ExtensionmodelPackage;
import org.eclipse.bpel.common.extension.model.adapters.ExtendedObjectAdapter;
import org.eclipse.bpel.common.extension.model.adapters.ExtendedObjectUserAdapter;
import org.eclipse.bpel.common.extension.model.adapters.impl.ExtendedObjectAdapterImpl;
import org.eclipse.bpel.common.extension.model.adapters.impl.ExtendedObjectUserAdapterImpl;
import org.eclipse.bpel.common.extension.model.adapters.impl.ExtensionAdapterImpl;
import org.eclipse.bpel.common.extension.model.adapters.impl.ExtensionMapAdapterImpl;
import org.eclipse.bpel.common.extension.model.notify.impl.ExtensionModelNotificationImpl;
import org.eclipse.bpel.common.extension.model.util.ExtensionmodelAdapterFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class ExtensionMapImpl
extends EObjectImpl
implements ExtensionMap {
    protected static final String NAMESPACE_EDEFAULT = null;
    protected String namespace = NAMESPACE_EDEFAULT;
    protected EList<Extension> extensions = null;
    private ExtendedObjectUserAdapter userAdapter = null;

    protected ExtensionMapImpl() {
    }

    protected EClass eStaticClass() {
        return ExtensionmodelPackage.eINSTANCE.getExtensionMap();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String newNamespace) {
        String oldNamespace = this.namespace;
        this.namespace = newNamespace;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldNamespace, (Object)this.namespace));
        }
    }

    public EList<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new EObjectContainmentEList(Extension.class, (InternalEObject)this, 1);
        }
        return this.extensions;
    }

    @Override
    public void initializeAdapter() {
        ExtensionmodelAdapterFactory factory = new ExtensionmodelAdapterFactory();
        if (this.userAdapter == null) {
            this.userAdapter = (ExtendedObjectUserAdapter)factory.createEObjectAdapter();
        }
        this.userAdapter.setExtensionMap(this);
        Set<EObject> extendedObjects = this.keySet();
        for (EObject element : extendedObjects) {
            this.adaptEObject(element, this.userAdapter);
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 1: {
                    return ((InternalEList)this.getExtensions()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getNamespace();
            }
            case 1: {
                return this.getExtensions();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setNamespace((String)newValue);
                return;
            }
            case 1: {
                this.getExtensions().clear();
                this.getExtensions().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setNamespace(NAMESPACE_EDEFAULT);
                return;
            }
            case 1: {
                this.getExtensions().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return NAMESPACE_EDEFAULT == null ? this.namespace != null : !NAMESPACE_EDEFAULT.equals(this.namespace);
            }
            case 1: {
                return this.extensions != null && !this.extensions.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (namespace: ");
        result.append(this.namespace);
        result.append(')');
        return result.toString();
    }

    @Override
    public int size() {
        return this.getExtensions().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getExtensions().isEmpty();
    }

    @Override
    public boolean containsKey(Object extendedObject) {
        if (extendedObject != null) {
            for (Extension extension : this.getExtensions()) {
                if (!extension.getExtendedObject().equals(extendedObject)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object extensionObject) {
        if (extensionObject != null) {
            for (Extension extension : this.getExtensions()) {
                if (!extension.getExtensionObject().equals(extensionObject)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public EObject get(Object extendedObject) {
        Extension extension = null;
        extension = this.getExtensionObject((EObject)extendedObject);
        if (extension != null) {
            return extension.getExtensionObject();
        }
        return null;
    }

    @Override
    public EObject put(EObject extendedObject, EObject extensionObject) {
        EObject originalObject = null;
        if (extendedObject != null && extensionObject != null) {
            Extension extension = this.getExtensionObject(extendedObject);
            if (extension != null) {
                originalObject = extension.getExtensionObject();
            } else {
                extension = ExtensionmodelFactory.eINSTANCE.createExtension();
                this.getExtensions().add((Object)extension);
            }
            extension.setExtendedObject(extendedObject);
            extension.setExtensionObject(extensionObject);
            ExtensionmodelAdapterFactory adapterFactory = new ExtensionmodelAdapterFactory();
            ExtendedObjectAdapter extAdptr = (ExtendedObjectAdapter)adapterFactory.createExtendedObjectAdapter();
            extAdptr.setExtension(extension);
            extAdptr.setNamespace(this.getNamespace());
            this.adaptEObject(extendedObject, extAdptr);
            adapterFactory.adapt((Notifier)extension, ExtensionAdapterImpl.class);
            if (this.userAdapter == null) {
                this.initializeAdapter();
            } else {
                this.adaptEObject(extendedObject, this.userAdapter);
            }
            if (this.eNotificationRequired()) {
                this.eNotify(new ExtensionModelNotificationImpl(this, 3, 996, extendedObject, originalObject));
            }
            return originalObject;
        }
        return null;
    }

    @Override
    public EObject remove(Object extendedObject) {
        if (extendedObject == null) {
            return null;
        }
        Extension extensionObject = this.getExtensionObject((EObject)extendedObject);
        if (this.getExtensions().contains((Object)extensionObject)) {
            EObject oldExtension = extensionObject.getExtensionObject();
            this.getExtensions().remove((Object)extensionObject);
            if (this.eNotificationRequired()) {
                this.eNotify(new ExtensionModelNotificationImpl(this, 4, 998, extendedObject, oldExtension));
            }
        }
        this.removeAdapters((EObject)extendedObject);
        if (extensionObject != null) {
            return extensionObject.getExtensionObject();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends EObject, ? extends EObject> extendedObjectMap) {
        Map<EObject, EObject> originalMap = null;
        if (this.eNotificationRequired()) {
            originalMap = this.buildMap();
        }
        if (extendedObjectMap != null && !extendedObjectMap.isEmpty()) {
            for (Map.Entry<? extends EObject, ? extends EObject> entry : extendedObjectMap.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.eNotificationRequired()) {
            this.eNotify(new ExtensionModelNotificationImpl(this, 5, 997, originalMap, null));
        }
    }

    @Override
    public void clear() {
        Map<EObject, EObject> originalMap = null;
        if (this.eNotificationRequired() && !this.getExtensions().isEmpty()) {
            originalMap = this.buildMap();
        }
        this.getExtensions().clear();
        if (originalMap != null) {
            int et = 6;
            if (originalMap.size() == 1) {
                et = 4;
            }
            this.eNotify(new ExtensionModelNotificationImpl(this, et, 999, originalMap, null));
        }
    }

    @Override
    public Set<EObject> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<EObject> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<EObject, EObject>> entrySet() {
        return new EntrySet<EObject, EObject>();
    }

    private Extension getExtensionObject(EObject extendedObject) {
        Extension extension = null;
        if (extendedObject != null) {
            for (Adapter element : extendedObject.eAdapters()) {
                if (!(element instanceof ExtendedObjectAdapter) || !((ExtendedObjectAdapter)element).getNamespace().equals(this.getNamespace())) continue;
                extension = ((ExtendedObjectAdapter)element).getExtension();
                break;
            }
            if (extension == null) {
                EList<Extension> extensions = this.getExtensions();
                int len = extensions.size();
                int i = 0;
                while (i < len) {
                    Extension ext = (Extension)extensions.get(i);
                    EObject extObject = ext.getExtendedObject();
                    if (extObject != null) {
                        if (ext.getExtendedObject().equals(extendedObject)) {
                            extension = ext;
                            ExtensionmodelAdapterFactory adapterFactory = new ExtensionmodelAdapterFactory();
                            ExtendedObjectAdapter extAdptr = (ExtendedObjectAdapter)adapterFactory.createExtendedObjectAdapter();
                            extAdptr.setExtension(extension);
                            extAdptr.setNamespace(this.getNamespace());
                            ExtensionmodelFactory.eINSTANCE.adaptEObject(extendedObject, extAdptr);
                            adapterFactory.adapt((Notifier)extension, ExtensionAdapterImpl.class);
                            break;
                        }
                        if (extObject.eIsProxy()) {
                            extensions.remove(i--);
                            --len;
                        }
                    }
                    ++i;
                }
            }
        }
        return extension;
    }

    public ExtendedObjectUserAdapter getUserAdapter() {
        return this.userAdapter;
    }

    private void adaptEObject(EObject target, Adapter adapter) {
        if (target != null && adapter != null) {
            for (Adapter next : target.eAdapters()) {
                if ((!(adapter instanceof ExtendedObjectUserAdapter) || !(next instanceof ExtendedObjectUserAdapter) || !((ExtendedObjectUserAdapter)next).getNamespace().equals(this.getNamespace())) && (!(adapter instanceof ExtendedObjectAdapter) || !(next instanceof ExtendedObjectAdapter) || !((ExtendedObjectAdapter)next).getNamespace().equals(this.getNamespace()))) continue;
                return;
            }
            target.eAdapters().add((Object)adapter);
        }
    }

    private void removeAdapters(EObject target) {
        if (target != null) {
            BasicEList removeAdapterList = new BasicEList();
            for (Adapter adapter : target.eAdapters()) {
                if ((!(adapter instanceof ExtendedObjectUserAdapter) || !((ExtendedObjectUserAdapter)adapter).getNamespace().equals(this.getNamespace())) && (!(adapter instanceof ExtendedObjectAdapter) || !((ExtendedObjectAdapter)adapter).getNamespace().equals(this.getNamespace()))) continue;
                removeAdapterList.add((Object)adapter);
            }
            for (Adapter next : removeAdapterList) {
                target.eAdapters().remove((Object)next);
            }
        }
    }

    private Map<EObject, EObject> buildMap() {
        boolean buildMap = false;
        for (Adapter element : this.eAdapters()) {
            if (element instanceof ExtendedObjectAdapterImpl || element instanceof ExtendedObjectUserAdapterImpl || element instanceof ExtensionAdapterImpl || element instanceof ExtensionMapAdapterImpl) continue;
            buildMap = true;
            break;
        }
        if (!buildMap) {
            return null;
        }
        HashMap<EObject, EObject> map = new HashMap<EObject, EObject>();
        for (Extension element : this.getExtensions()) {
            map.put(element.getExtendedObject(), element.getExtensionObject());
        }
        return map;
    }

    public abstract class EIterator<T>
    implements Iterator<T> {
        Iterator<Extension> fieldListIterator;

        public EIterator() {
            this.fieldListIterator = ExtensionMapImpl.this.getExtensions().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.fieldListIterator.hasNext();
        }

        @Override
        public T next() {
            Extension object = this.fieldListIterator.next();
            if (object == null) {
                return null;
            }
            return this.next(object);
        }

        protected abstract T next(Extension var1);

        @Override
        public void remove() {
            this.fieldListIterator.remove();
        }
    }

    public class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        public Entry(K aKey, V aValue) {
            this.key = aKey;
            this.value = aValue;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V aValue) {
            V oldValue = this.value;
            this.value = aValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.key == null ? 0 : this.key.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        protected EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EIterator<Map.Entry<K, V>>(ExtensionMapImpl.this){

                @Override
                protected Map.Entry<K, V> next(Extension extension) {
                    return new Entry<EObject, EObject>(extension.getExtendedObject(), extension.getExtensionObject());
                }
            };
        }

        @Override
        public int size() {
            int n = 0;
            Iterator<Map.Entry<K, V>> i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++n;
            }
            return n;
        }
    }

    public class KeySet
    extends AbstractSet<EObject> {
        protected KeySet() {
        }

        @Override
        public Iterator<EObject> iterator() {
            return new EIterator<EObject>(ExtensionMapImpl.this){

                @Override
                protected EObject next(Extension extension) {
                    return extension.getExtendedObject();
                }
            };
        }

        @Override
        public int size() {
            int n = 0;
            Iterator<EObject> i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++n;
            }
            return n;
        }
    }

    public class Values
    extends AbstractCollection<EObject> {
        protected Values() {
        }

        @Override
        public Iterator<EObject> iterator() {
            return new EIterator<EObject>(ExtensionMapImpl.this){

                @Override
                protected EObject next(Extension extension) {
                    return extension.getExtensionObject();
                }
            };
        }

        @Override
        public int size() {
            int n = 0;
            Iterator<EObject> i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++n;
            }
            return n;
        }
    }
}

