/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.dialogs;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.JoinHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.dialogs.DefineTypeComposite;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SourceTargetDialog
extends Dialog {
    Combo srcColumnField;
    Vector allSrcColumn = new Vector();
    Combo srcTableField;
    Combo tgtTableField;
    Vector tableCache = new Vector();
    Combo tgtColumnField;
    Vector allTgtColumn = new Vector();
    ValueExpressionColumn sourceColumn;
    TableExpression targetTable;
    ValueExpressionColumn targetColumn;
    TableExpression sourceTable;
    QuerySelect querySelect;
    String dialogInstr = Messages._UI_DIALOG_SOURCE_AND_TARGET_TEXT;
    ComboBoxModifyListener comboModifyListener = new ComboBoxModifyListener();
    DefineTypeComposite defineTypeComposite;
    SQLDomainModel domainModel;
    int joinType = 0;
    Label srcType;
    Label targetType;

    public SourceTargetDialog(Shell shell, TableExpression srcTable, QuerySelect qSelect, SQLDomainModel domainModel) {
        super(shell);
        this.sourceTable = srcTable;
        this.querySelect = qSelect;
        this.domainModel = domainModel;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages._UI_DIALOG_SOURCE_AND_TARGET_TITLE);
    }

    public void initializeTableCombos() {
        this.populateWithTableCoulmns(this.sourceTable, this.srcColumnField, this.allSrcColumn);
        List tableList = StatementHelper.getTableExpressionsInQuerySelect((QuerySelect)this.querySelect);
        for (TableExpression table : tableList) {
            String tableName = table.getName();
            this.tableCache.addElement(table);
            this.srcTableField.add(tableName);
            this.tgtTableField.add(tableName);
        }
        if (this.allSrcColumn.size() > 0) {
            this.srcColumnField.select(0);
        }
        this.srcTableField.select(this.srcTableField.indexOf(this.sourceTable.getName()));
        this.tgtTableField.select(0);
        TableExpression tableExpr = (TableExpression)this.tableCache.elementAt(0);
        this.populateWithTableCoulmns(tableExpr, this.tgtColumnField, this.allTgtColumn);
        this.setTypes();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.joinType = this.defineTypeComposite.getJoinKind();
            int index = this.tgtTableField.getSelectionIndex();
            this.targetTable = index < 0 ? null : (TableExpression)this.tableCache.elementAt(index);
            index = this.srcTableField.getSelectionIndex();
            this.sourceTable = index < 0 ? null : (TableExpression)this.tableCache.elementAt(index);
            index = this.srcColumnField.getSelectionIndex();
            this.sourceColumn = index < 0 ? null : (ValueExpressionColumn)this.allSrcColumn.get(index);
            index = this.tgtColumnField.getSelectionIndex();
            this.targetColumn = index < 0 ? null : (ValueExpressionColumn)this.allTgtColumn.get(index);
            EList fromContent = this.querySelect.getFromClause();
            int status = JoinHelper.checkJoin((List)fromContent, (TableExpression)this.sourceTable, (TableExpression)this.targetTable, (ValueExpressionColumn)this.sourceColumn, (ValueExpressionColumn)this.targetColumn, (boolean)false);
            if (status != 0) {
                MessageBox message = new MessageBox(this.getShell(), 33);
                message.setText(Messages._UI_MSG_INVALID_JOIN_TITLE);
                String lineSeparator = System.getProperties().getProperty("line.separator");
                String msgStr = Messages._WARN_INVALID_JOIN;
                if (status == -1) {
                    msgStr = Messages._WARN_BAD_JOIN_1;
                    msgStr = String.valueOf(msgStr) + lineSeparator;
                    msgStr = String.valueOf(msgStr) + NLS.bind((String)Messages._WARN_BAD_JOIN_TYPES, (Object)this.sourceColumn, (Object)this.sourceColumn.getDataType().getName());
                    msgStr = String.valueOf(msgStr) + lineSeparator;
                    msgStr = String.valueOf(msgStr) + NLS.bind((String)Messages._WARN_BAD_JOIN_TYPES, (Object)this.targetColumn, (Object)this.targetColumn.getDataType().getName());
                } else if (status == -2) {
                    msgStr = Messages._WARN_COLUMN_USED;
                }
                message.setMessage(msgStr);
                message.open();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public TableExpression getTargetTable() {
        return this.targetTable;
    }

    public TableExpression getSourceTable() {
        return this.sourceTable;
    }

    public ValueExpressionColumn getSourceColumn() {
        return this.sourceColumn;
    }

    public ValueExpressionColumn getTargetColumn() {
        return this.targetColumn;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public Control createDialogArea(Composite parent) {
        Composite client = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)client, "org.eclipse.datatools.sqltools.sqlbuilder.sqlg0022");
        GridLayout layout = (GridLayout)client.getLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        client.setLayout((Layout)layout);
        GridData gData = (GridData)client.getLayoutData();
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        client.setLayoutData((Object)gData);
        Group grp1 = ViewUtility.createGroup(client, 2, Messages._UI_GROUP_SOURCE, false);
        ViewUtility.createLabel((Composite)grp1, Messages._UI_LABEL_TARGET_TABLE);
        this.srcTableField = ViewUtility.createComboBox((Composite)grp1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.srcTableField, "org.eclipse.datatools.sqltools.sqlbuilder.sqlg0022");
        ViewUtility.createLabel((Composite)grp1, Messages._UI_LABEL_COLUMN);
        this.srcColumnField = ViewUtility.createComboBox((Composite)grp1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.srcColumnField, "org.eclipse.datatools.sqltools.sqlbuilder.sqlg0022");
        ViewUtility.createLabel((Composite)grp1, Messages._UI_LABEL_JOIN_SRCCOL_TYPE);
        this.srcType = ViewUtility.createLabel((Composite)grp1, "");
        Group grp2 = ViewUtility.createGroup(client, 2, Messages._UI_GROUP_TARGET, false);
        ViewUtility.createLabel((Composite)grp2, Messages._UI_LABEL_TABLE);
        this.tgtTableField = ViewUtility.createComboBox((Composite)grp2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tgtTableField, "org.eclipse.datatools.sqltools.sqlbuilder.sqlg0022");
        ViewUtility.createLabel((Composite)grp2, Messages._UI_LABEL_TARGET_COLUMN);
        this.tgtColumnField = ViewUtility.createComboBox((Composite)grp2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tgtColumnField, "org.eclipse.datatools.sqltools.sqlbuilder.sqlg0022");
        ViewUtility.createLabel((Composite)grp2, Messages._UI_LABEL_JOIN_TGTCOL_TYPE);
        this.targetType = ViewUtility.createLabel((Composite)grp2, "");
        this.defineTypeComposite = new DefineTypeComposite(client, this.domainModel, 0);
        Composite typeComposite = this.defineTypeComposite.getControl();
        GridData typeGridData = (GridData)typeComposite.getLayoutData();
        typeGridData.grabExcessHorizontalSpace = true;
        typeGridData.grabExcessVerticalSpace = true;
        typeComposite.setLayoutData((Object)typeGridData);
        this.initializeTableCombos();
        this.srcTableField.forceFocus();
        this.srcColumnField.addModifyListener((ModifyListener)this.comboModifyListener);
        this.srcTableField.addModifyListener((ModifyListener)this.comboModifyListener);
        this.tgtColumnField.addModifyListener((ModifyListener)this.comboModifyListener);
        this.tgtTableField.addModifyListener((ModifyListener)this.comboModifyListener);
        return client;
    }

    public void setTypes() {
        DataType type;
        int index = this.srcColumnField.getSelectionIndex();
        if (index < 0) {
            Object srcColumn = null;
            this.srcType.setText("");
        } else {
            ValueExpressionColumn srcColumn = (ValueExpressionColumn)this.allSrcColumn.get(index);
            type = srcColumn.getDataType();
            if (type != null) {
                this.srcType.setText(type.getName());
            }
        }
        index = this.tgtColumnField.getSelectionIndex();
        if (index < 0) {
            Object tgtColumn = null;
            this.targetType.setText("");
        } else {
            ValueExpressionColumn tgtColumn = (ValueExpressionColumn)this.allTgtColumn.get(index);
            type = tgtColumn.getDataType();
            if (type != null) {
                this.targetType.setText(type.getName());
            }
        }
    }

    void populateWithTableCoulmns(TableExpression table, Combo combo, Vector colVector) {
        EList colList = table.getColumnList();
        Iterator itr = colList.iterator();
        combo.removeAll();
        colVector.clear();
        while (itr.hasNext()) {
            ValueExpressionColumn col = (ValueExpressionColumn)itr.next();
            colVector.add(col);
            combo.add(col.getName());
        }
        combo.select(0);
    }

    private class ComboBoxModifyListener
    implements ModifyListener {
        private ComboBoxModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (SourceTargetDialog.this.srcTableField.getSelectionIndex() >= 0 && SourceTargetDialog.this.tgtTableField.getSelectionIndex() >= 0) {
                SourceTargetDialog.this.srcColumnField.removeModifyListener((ModifyListener)SourceTargetDialog.this.comboModifyListener);
                SourceTargetDialog.this.srcTableField.removeModifyListener((ModifyListener)SourceTargetDialog.this.comboModifyListener);
                SourceTargetDialog.this.tgtColumnField.removeModifyListener((ModifyListener)SourceTargetDialog.this.comboModifyListener);
                SourceTargetDialog.this.tgtTableField.removeModifyListener((ModifyListener)SourceTargetDialog.this.comboModifyListener);
                if (e.widget == SourceTargetDialog.this.tgtTableField || e.widget == SourceTargetDialog.this.srcColumnField) {
                    int index = SourceTargetDialog.this.tgtTableField.getSelectionIndex();
                    if (index < 0) {
                        return;
                    }
                    if (e.widget == SourceTargetDialog.this.tgtTableField) {
                        TableExpression tableExpr = (TableExpression)SourceTargetDialog.this.tableCache.elementAt(index);
                        SourceTargetDialog.this.populateWithTableCoulmns(tableExpr, SourceTargetDialog.this.tgtColumnField, SourceTargetDialog.this.allTgtColumn);
                    }
                    if (SourceTargetDialog.this.sourceTable == SourceTargetDialog.this.targetTable) {
                        SourceTargetDialog.this.tgtColumnField.select(SourceTargetDialog.this.srcColumnField.getSelectionIndex());
                    }
                } else if (e.widget == SourceTargetDialog.this.srcTableField || e.widget == SourceTargetDialog.this.tgtColumnField) {
                    int index = SourceTargetDialog.this.srcTableField.getSelectionIndex();
                    if (index < 0) {
                        return;
                    }
                    if (e.widget == SourceTargetDialog.this.srcTableField) {
                        TableExpression tableExpr = (TableExpression)SourceTargetDialog.this.tableCache.elementAt(index);
                        SourceTargetDialog.this.populateWithTableCoulmns(tableExpr, SourceTargetDialog.this.srcColumnField, SourceTargetDialog.this.allSrcColumn);
                    }
                    if (SourceTargetDialog.this.sourceTable == SourceTargetDialog.this.targetTable) {
                        SourceTargetDialog.this.srcColumnField.select(SourceTargetDialog.this.tgtColumnField.getSelectionIndex());
                    }
                }
                SourceTargetDialog.this.setTypes();
                SourceTargetDialog.this.srcColumnField.addModifyListener((ModifyListener)SourceTargetDialog.this.comboModifyListener);
                SourceTargetDialog.this.srcTableField.addModifyListener((ModifyListener)SourceTargetDialog.this.comboModifyListener);
                SourceTargetDialog.this.tgtColumnField.addModifyListener((ModifyListener)SourceTargetDialog.this.comboModifyListener);
                SourceTargetDialog.this.tgtTableField.addModifyListener((ModifyListener)SourceTargetDialog.this.comboModifyListener);
            }
        }
    }
}

