/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.serializer;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.ws.commons.serialize.XMLWriter;
import org.apache.ws.commons.serialize.XMLWriterImpl;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.serializer.XmlWriterFactory;
import org.xml.sax.ContentHandler;

public class BaseXmlWriterFactory
implements XmlWriterFactory {
    protected XMLWriter newXmlWriter() {
        return new XMLWriterImpl();
    }

    @Override
    public ContentHandler getXmlWriter(XmlRpcStreamConfig pConfig, OutputStream pStream) throws XmlRpcException {
        XMLWriter xw = this.newXmlWriter();
        xw.setDeclarating(true);
        String enc = pConfig.getEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        xw.setEncoding(enc);
        xw.setIndenting(false);
        xw.setFlushing(true);
        try {
            xw.setWriter((Writer)new BufferedWriter(new OutputStreamWriter(pStream, enc)));
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlRpcException("Unsupported encoding: " + enc, e);
        }
        return xw;
    }
}

