/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.linear;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.math3.exception.TooManyIterationsException;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;

public abstract class LinearOptimizer
extends MultivariateOptimizer {
    private LinearObjectiveFunction function;
    private Collection<LinearConstraint> linearConstraints;
    private boolean nonNegative;

    protected LinearOptimizer() {
        super((ConvergenceChecker<PointValuePair>)null);
    }

    protected boolean isRestrictedToNonNegative() {
        return this.nonNegative;
    }

    protected LinearObjectiveFunction getFunction() {
        return this.function;
    }

    protected Collection<LinearConstraint> getConstraints() {
        return Collections.unmodifiableCollection(this.linearConstraints);
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optData) throws TooManyIterationsException {
        return super.optimize(optData);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        OptimizationData[] optimizationDataArray = optData;
        int n = optData.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizationData data = optimizationDataArray[n2];
            if (data instanceof LinearObjectiveFunction) {
                this.function = (LinearObjectiveFunction)data;
            } else if (data instanceof LinearConstraintSet) {
                this.linearConstraints = ((LinearConstraintSet)data).getConstraints();
            } else if (data instanceof NonNegativeConstraint) {
                this.nonNegative = ((NonNegativeConstraint)data).isRestrictedToNonNegative();
            }
            ++n2;
        }
    }
}

