/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.model.Environment;
import com.google.caliper.model.Result;
import com.google.caliper.model.Run;
import com.google.caliper.model.VM;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.Scenario;
import com.google.caliper.runner.TrialResult;
import com.google.caliper.runner.VirtualMachine;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class ResultDataWriter {
    private static final String ENVIRONMENT_LOCAL_NAME = "A";
    private static final String INSTRUMENT_LOCAL_NAME = "A";
    private Run run = new Run();
    private final BiMap<VirtualMachine, String> virtualMachineLocalNames = HashBiMap.create();
    private final BiMap<Scenario, String> scenarioLocalNames = HashBiMap.create();

    public Run getRun() {
        Run oldRun = this.run;
        this.run = new Run();
        this.virtualMachineLocalNames.clear();
        this.scenarioLocalNames.clear();
        return oldRun;
    }

    public String writeEnvironment(Environment env) {
        Preconditions.checkState((boolean)this.run.environments.isEmpty());
        Environment copy = new Environment();
        copy.properties = Maps.newTreeMap(env.properties);
        copy.localName = (String)Objects.firstNonNull((Object)env.localName, (Object)"A");
        this.run.environments.add(copy);
        return copy.localName;
    }

    public String writeVM(VirtualMachine virtualMachine) {
        String localName = (String)this.virtualMachineLocalNames.get((Object)virtualMachine);
        if (localName != null) {
            return localName;
        }
        VM vm = new VM();
        vm.localName = virtualMachine.name;
        vm.vmName = virtualMachine.name;
        vm.detectedProperties = virtualMachine.detectProperties();
        this.run.vms.add(vm);
        this.virtualMachineLocalNames.put((Object)virtualMachine, (Object)vm.localName);
        return vm.localName;
    }

    public String writeInstrument(Instrument instrument) {
        Preconditions.checkState((boolean)this.run.instruments.isEmpty());
        com.google.caliper.model.Instrument modelInstrument = new com.google.caliper.model.Instrument();
        modelInstrument.localName = "A";
        modelInstrument.className = instrument.getClass().getName();
        modelInstrument.properties = new TreeMap<String, String>((Map<String, String>)instrument.options);
        this.run.instruments.add(modelInstrument);
        return "A";
    }

    public void writeTrialResult(TrialResult trialResult) {
        Scenario scenario = trialResult.getScenario();
        String vmLocalName = this.writeVM(scenario.vm());
        String scenarioLocalName = this.writeScenario(scenario, vmLocalName);
        this.writeResult(scenarioLocalName, trialResult);
    }

    private String writeScenario(Scenario scenario, String vmLocalName) {
        String localName = (String)this.scenarioLocalNames.get((Object)scenario);
        if (localName != null) {
            return localName;
        }
        localName = this.generateUniqueName(this.run.scenarios.size());
        com.google.caliper.model.Scenario modelScenario = new com.google.caliper.model.Scenario();
        modelScenario.localName = localName;
        modelScenario.benchmarkMethodName = scenario.benchmarkMethod().name();
        modelScenario.benchmarkClassName = scenario.benchmarkMethod().className();
        modelScenario.vmLocalName = vmLocalName;
        modelScenario.vmArguments = new TreeMap<String, String>((SortedMap<String, String>)scenario.vmArguments());
        modelScenario.environmentLocalName = "A";
        modelScenario.userParameters = new TreeMap<String, String>((SortedMap<String, String>)scenario.userParameters());
        this.run.scenarios.add(modelScenario);
        this.scenarioLocalNames.put((Object)scenario, (Object)localName);
        return localName;
    }

    private void writeResult(String scenarioLocalName, TrialResult trialResult) {
        Result result = new Result();
        result.localName = this.generateUniqueName(this.run.results.size());
        result.scenarioLocalName = scenarioLocalName;
        result.instrumentLocalName = "A";
        result.measurements = ImmutableList.copyOf(trialResult.getMeasurements());
        result.messages = ImmutableList.copyOf(trialResult.getMessages());
        result.vmCommandLine = trialResult.getVmCommandLine();
        this.run.results.add(result);
    }

    private String generateUniqueName(int index) {
        if (index < 26) {
            return String.valueOf((char)(65 + index));
        }
        return this.generateUniqueName(index / 26 - 1) + this.generateUniqueName(index % 26);
    }
}

