/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.ZooKeeperMain;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.utils.AttributedString;

class JLineZNodeCompleter
implements Completer {
    private final ZooKeeper zk;

    public JLineZNodeCompleter(ZooKeeper zk) {
        this.zk = zk;
    }

    public void complete(LineReader lineReader, ParsedLine commandLine, List<Candidate> candidates) {
        String token = (String)commandLine.words().get(commandLine.words().size() - 1);
        if (token.startsWith("/")) {
            this.completeZNode(token, candidates);
        } else {
            this.completeCommand(token, candidates);
        }
    }

    private void completeCommand(String token, List<Candidate> candidates) {
        for (String cmd : ZooKeeperMain.getCommands()) {
            if (!cmd.startsWith(token)) continue;
            candidates.add(JLineZNodeCompleter.createCandidate(cmd));
        }
    }

    private void completeZNode(String token, List<Candidate> candidates) {
        String path = token;
        int idx = path.lastIndexOf("/") + 1;
        String prefix = path.substring(idx);
        try {
            String dir = idx == 1 ? "/" : path.substring(0, idx - 1);
            List<String> children = this.zk.getChildren(dir, false);
            for (String child : children) {
                if (!child.startsWith(prefix)) continue;
                String zNode = dir + (idx == 1 ? "" : "/") + child;
                candidates.add(JLineZNodeCompleter.createCandidate(zNode));
            }
        }
        catch (InterruptedException | KeeperException e) {
            return;
        }
        Collections.sort(candidates);
    }

    private static Candidate createCandidate(String cmd) {
        return new Candidate(AttributedString.stripAnsi((String)cmd), cmd, null, null, null, null, true);
    }
}

