/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.check;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.ruta.caseditor.view.tree.TypeTreeNode;
import org.apache.uima.ruta.check.CheckElement;
import org.apache.uima.ruta.check.FeatureCheckTreeNode;
import org.apache.uima.ruta.check.IAnnotationCheckTreeNode;

public class AnnotationCheckTreeNode
implements IAnnotationCheckTreeNode {
    protected List<AnnotationCheckTreeNode> children;
    private IAnnotationCheckTreeNode parent;
    private CheckElement element;
    private LinkedList<TypeTreeNode> typeTreeNodes;

    public AnnotationCheckTreeNode(IAnnotationCheckTreeNode parent, CheckElement element) {
        this.parent = parent;
        this.children = new ArrayList<AnnotationCheckTreeNode>();
        this.element = element;
        this.typeTreeNodes = new LinkedList();
    }

    @Override
    public void addChild(AnnotationCheckTreeNode child) {
        this.children.add(child);
    }

    @Override
    public AnnotationCheckTreeNode[] getChildren() {
        if (this.children.isEmpty()) {
            return new FeatureCheckTreeNode[0];
        }
        if (this.children.get(0) instanceof FeatureCheckTreeNode) {
            return this.children.toArray(new FeatureCheckTreeNode[0]);
        }
        return this.children.toArray(new AnnotationCheckTreeNode[0]);
    }

    @Override
    public Iterator<AnnotationCheckTreeNode> getChildrenIterator() {
        return this.children.iterator();
    }

    @Override
    public String getName() {
        return "AbstractAnnotationCheckTreeNode";
    }

    @Override
    public IAnnotationCheckTreeNode getParent() {
        return this.parent;
    }

    @Override
    public CheckElement getElement() {
        return this.element;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setChildren(List<AnnotationCheckTreeNode> children) {
        this.children = children;
    }

    public void swapChilds(AnnotationCheckTreeNode child1, AnnotationCheckTreeNode child2) {
        int index1 = this.children.indexOf(child1);
        int index2 = this.children.indexOf(child2);
        if (index1 > -1 && index2 > -1) {
            this.children.set(index1, child2);
            this.children.set(index2, child1);
        }
    }

    public void addTypeChildNode(TypeTreeNode typeTreeNode) {
        if (!this.typeTreeNodes.contains(typeTreeNode)) {
            this.typeTreeNodes.add(typeTreeNode);
        }
    }
}

