/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import org.apache.tapestry5.internal.plastic.InstructionBuilderState;
import org.apache.tapestry5.internal.plastic.Lockable;
import org.apache.tapestry5.internal.plastic.asm.Label;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.TryCatchBlock;
import org.apache.tapestry5.plastic.TryCatchCallback;

public class TryCatchBlockImpl
extends Lockable
implements TryCatchBlock {
    private final InstructionBuilder builder;
    private final InstructionBuilderState state;
    private final Label startLabel;
    private final Label endLabel;

    TryCatchBlockImpl(InstructionBuilder builder, InstructionBuilderState state) {
        this.builder = builder;
        this.state = state;
        this.startLabel = new Label();
        this.endLabel = new Label();
    }

    @Override
    public void addTry(InstructionBuilderCallback callback) {
        this.state.visitor.visitLabel(this.startLabel);
        callback.doBuild(this.builder);
        this.state.visitor.visitLabel(this.endLabel);
    }

    @Override
    public void addCatch(String exceptionClassName, InstructionBuilderCallback callback) {
        assert (exceptionClassName != null);
        this.doCatch(this.state.nameCache.toInternalName(exceptionClassName), callback);
    }

    private void doCatch(String exceptionInternalName, InstructionBuilderCallback callback) {
        this.check();
        Label handler = this.state.newLabel();
        callback.doBuild(this.builder);
        this.state.visitor.visitTryCatchBlock(this.startLabel, this.endLabel, handler, exceptionInternalName);
    }

    @Override
    public void addFinally(InstructionBuilderCallback callback) {
        this.doCatch(null, callback);
    }

    void doCallback(TryCatchCallback callback) {
        assert (callback != null);
        callback.doBlock(this);
        this.lock();
    }
}

