/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.binder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester3.RuleSet;
import org.apache.commons.digester3.binder.ErrorMessage;
import org.apache.commons.digester3.binder.FromBinderRuleSet;
import org.apache.commons.digester3.binder.LinkedRuleBuilder;
import org.apache.commons.digester3.binder.RulesBinder;
import org.apache.commons.digester3.binder.RulesModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultRulesBinder
implements RulesBinder {
    private final List<ErrorMessage> errors = new ArrayList<ErrorMessage>();
    private final FromBinderRuleSet fromBinderRuleSet = new FromBinderRuleSet();
    private ClassLoader classLoader;

    DefaultRulesBinder() {
    }

    void initialize(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.fromBinderRuleSet.clear();
        this.errors.clear();
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.classLoader;
    }

    @Override
    public void addError(String messagePattern, Object ... arguments) {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        StackTraceElement element = null;
        for (int stackIndex = stackTrace.length - 1; element == null && stackIndex > 0; --stackIndex) {
            Class<?> moduleClass;
            try {
                moduleClass = Class.forName(stackTrace[stackIndex].getClassName(), false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                try {
                    moduleClass = Class.forName(stackTrace[stackIndex].getClassName(), false, this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException e1) {
                    moduleClass = null;
                }
            }
            if (moduleClass == null || !RulesModule.class.isAssignableFrom(moduleClass)) continue;
            element = stackTrace[stackIndex];
        }
        if (element != null) {
            messagePattern = String.format("%s (%s:%s)", messagePattern, element.getFileName(), element.getLineNumber());
        }
        this.addError(new ErrorMessage(messagePattern, arguments));
    }

    @Override
    public void addError(Throwable t) {
        String message = "An exception was caught and reported. Message: " + t.getMessage();
        this.addError(new ErrorMessage(message, t));
    }

    private void addError(ErrorMessage errorMessage) {
        this.errors.add(errorMessage);
    }

    @Override
    public void install(RulesModule rulesModule) {
        rulesModule.configure(this);
    }

    @Override
    public LinkedRuleBuilder forPattern(String pattern) {
        String keyPattern;
        if (pattern == null || pattern.length() == 0) {
            this.addError("Null or empty pattern is not valid", new Object[0]);
            keyPattern = null;
        } else {
            keyPattern = pattern.endsWith("/") ? pattern.substring(0, pattern.length() - 1) : pattern;
        }
        return new LinkedRuleBuilder(this, this.fromBinderRuleSet, this.classLoader, keyPattern);
    }

    boolean hasError() {
        return !this.errors.isEmpty();
    }

    int errorsSize() {
        return this.errors.size();
    }

    Iterable<ErrorMessage> getErrors() {
        return this.errors;
    }

    RuleSet getFromBinderRuleSet() {
        return this.fromBinderRuleSet;
    }
}

