/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts2.views.jasperreports7;

import org.apache.struts2.util.ValueStack;

import java.util.HashMap;
import java.util.Objects;


/**
 * Ported to Struts:
 */
public class ValueStackShadowMap extends HashMap<String, Object> {

    /**
     * valueStack reference
     */
    transient ValueStack valueStack;

    /**
     * Constructs an instance of ValueStackShadowMap.
     *
     * @param valueStack - the underlying valuestack
     */
    public ValueStackShadowMap(ValueStack valueStack) {
        this.valueStack = valueStack;
    }


    /**
     * Implementation of containsKey(), overriding HashMap implementation.
     *
     * @param key - The key to check in HashMap and if not found to check on valueStack.
     * @return <tt>true</tt>, if contains key, <tt>false</tt> otherwise.
     * @see java.util.HashMap#containsKey
     */
    @Override
    public boolean containsKey(Object key) {
        boolean hasKey = super.containsKey(key);

        if (!hasKey && key != null && valueStack.findValue(key.toString()) != null) {
            hasKey = true;
        }

        return hasKey;
    }

    /**
     * Implementation of get(), overriding HashMap implementation.
     *
     * @param key - The key to get in HashMap and if not found there from the valueStack.
     * @return value - The object from HashMap or if null, from the valueStack.
     * @see java.util.HashMap#get
     */
    @Override
    public Object get(Object key) {
        Object value = super.get(key);

        if (key != null && value == null) {
            value = valueStack.findValue(key.toString());
        }

        return value;
    }
}
