/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config_browser;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionContext;
import org.apache.struts2.config_browser.ListValidatorsAction;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.apache.struts2.util.reflection.ReflectionException;
import org.apache.struts2.util.reflection.ReflectionProvider;
import org.apache.struts2.validator.Validator;

public class ShowValidatorAction
extends ListValidatorsAction {
    private static final long serialVersionUID = 4061534149317835177L;
    private static final Logger LOG = LogManager.getLogger(ShowValidatorAction.class);
    private Set<PropertyInfo> properties = Collections.emptySet();
    private int selected = 0;
    private ReflectionProvider reflectionProvider;

    @Inject
    public void setReflectionProvider(ReflectionProvider prov) {
        this.reflectionProvider = prov;
    }

    public int getSelected() {
        return this.selected;
    }

    @StrutsParameter
    public void setSelected(int selected) {
        this.selected = selected;
    }

    public Set getProperties() {
        return this.properties;
    }

    public Validator getSelectedValidator() {
        return (Validator)this.validators.get(this.selected);
    }

    @Override
    public String execute() throws Exception {
        this.loadValidators();
        Validator validator = this.getSelectedValidator();
        this.properties = new TreeSet<PropertyInfo>();
        try {
            BeanInfo beanInfoFrom;
            try {
                beanInfoFrom = Introspector.getBeanInfo(validator.getClass(), Object.class);
            }
            catch (IntrospectionException e) {
                LOG.error("An error occurred", (Throwable)e);
                this.addActionError("An error occurred while introspecting a validator of type " + validator.getClass().getName());
                return "error";
            }
            PropertyDescriptor[] pds = beanInfoFrom.getPropertyDescriptors();
            Map context = ActionContext.getContext().getContextMap();
            for (PropertyDescriptor pd : pds) {
                String name = pd.getName();
                Object value = null;
                if (pd.getReadMethod() == null) {
                    value = "No read method for property";
                } else {
                    try {
                        value = this.reflectionProvider.getValue(name, context, (Object)validator);
                    }
                    catch (ReflectionException e) {
                        this.addActionError("Caught exception while getting property value for '" + name + "' on validator of type " + validator.getClass().getName());
                    }
                }
                this.properties.add(new PropertyInfo(name, pd.getPropertyType(), value));
            }
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unable to retrieve properties.", (Throwable)e);
            }
            this.addActionError("Unable to retrieve properties: " + String.valueOf(e));
        }
        if (this.hasErrors()) {
            return "error";
        }
        return "success";
    }

    public static class PropertyInfo
    implements Comparable {
        private String name;
        private Class type;
        private Object value;

        public PropertyInfo(String name, Class type, Object value) {
            if (name == null) {
                throw new IllegalArgumentException("Name must not be null");
            }
            if (type == null) {
                throw new IllegalArgumentException("Type must not be null");
            }
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public Class getType() {
            return this.type;
        }

        public void setType(Class type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyInfo)) {
                return false;
            }
            PropertyInfo propertyInfo = (PropertyInfo)o;
            if (!this.name.equals(propertyInfo.name)) {
                return false;
            }
            if (!this.type.equals(propertyInfo.type)) {
                return false;
            }
            return Objects.equals(this.value, propertyInfo.value);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 29 * result + this.type.hashCode();
            result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public int compareTo(Object o) {
            PropertyInfo other = (PropertyInfo)o;
            return this.name.compareTo(other.name);
        }
    }
}

