/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.setup;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockFilterRegistration;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;
import org.springframework.web.util.UrlPathHelper;

final class MockMvcFilterDecorator
implements Filter {
    private static final String ALL_MAPPING_PATTERN = "*";
    private static final String EXTENSION_MAPPING_PATTERN = "*.";
    private static final String PATH_MAPPING_PATTERN = "/*";
    private final Filter delegate;
    @Nullable
    private final Function<ServletContext, FilterConfig> filterConfigInitializer;
    @Nullable
    private final EnumSet<DispatcherType> dispatcherTypes;
    private final boolean hasPatterns;
    private final List<String> exactMatches = new ArrayList<String>();
    private final List<String> startsWithMatches = new ArrayList<String>();
    private final List<String> endsWithMatches = new ArrayList<String>();

    public MockMvcFilterDecorator(Filter delegate, String[] urlPatterns) {
        Assert.notNull((Object)delegate, (String)"filter cannot be null");
        Assert.notNull((Object)urlPatterns, (String)"urlPatterns cannot be null");
        this.delegate = delegate;
        this.filterConfigInitializer = null;
        this.dispatcherTypes = null;
        this.hasPatterns = this.initPatterns(urlPatterns);
    }

    public MockMvcFilterDecorator(Filter delegate, @Nullable String filterName, @Nullable Map<String, String> initParams, @Nullable EnumSet<DispatcherType> dispatcherTypes, String ... urlPatterns) {
        Assert.notNull((Object)delegate, (String)"filter cannot be null");
        Assert.notNull((Object)urlPatterns, (String)"urlPatterns cannot be null");
        this.delegate = delegate;
        this.filterConfigInitializer = MockMvcFilterDecorator.getFilterConfigInitializer(delegate, filterName, initParams);
        this.dispatcherTypes = dispatcherTypes;
        this.hasPatterns = this.initPatterns(urlPatterns);
    }

    private static Function<ServletContext, FilterConfig> getFilterConfigInitializer(Filter delegate, @Nullable String filterName, @Nullable Map<String, String> initParams) {
        String className = delegate.getClass().getName();
        return servletContext -> {
            MockFilterConfig filterConfig;
            MockFilterConfig mockFilterConfig = filterConfig = filterName != null ? new MockFilterConfig((ServletContext)servletContext, filterName) : new MockFilterConfig((ServletContext)servletContext);
            if (initParams != null) {
                initParams.forEach(filterConfig::addInitParameter);
            }
            if (servletContext instanceof MockServletContext) {
                MockServletContext mockServletContext = (MockServletContext)servletContext;
                mockServletContext.addFilterRegistration((FilterRegistration)(filterName != null ? new MockFilterRegistration(className, filterName) : new MockFilterRegistration(className)));
            }
            return filterConfig;
        };
    }

    private boolean initPatterns(String ... urlPatterns) {
        for (String urlPattern : urlPatterns) {
            Assert.notNull((Object)urlPattern, (String)"Found null URL Pattern");
            if (urlPattern.startsWith(EXTENSION_MAPPING_PATTERN)) {
                this.endsWithMatches.add(urlPattern.substring(1));
                continue;
            }
            if (urlPattern.equals(PATH_MAPPING_PATTERN) || urlPattern.equals(ALL_MAPPING_PATTERN)) {
                this.startsWithMatches.add("");
                continue;
            }
            if (urlPattern.endsWith(PATH_MAPPING_PATTERN)) {
                this.startsWithMatches.add(urlPattern.substring(0, urlPattern.length() - 1));
                this.exactMatches.add(urlPattern.substring(0, urlPattern.length() - 2));
                continue;
            }
            if (urlPattern.isEmpty()) {
                urlPattern = "/";
            }
            this.exactMatches.add(urlPattern);
        }
        return urlPatterns.length != 0;
    }

    public void doFilter(ServletRequest request2, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request2;
        String requestPath = UrlPathHelper.defaultInstance.getPathWithinApplication(httpRequest);
        if (this.matchDispatcherType(httpRequest.getDispatcherType()) && this.matchRequestPath(requestPath)) {
            this.delegate.doFilter(request2, response, filterChain);
        } else {
            filterChain.doFilter(request2, response);
        }
    }

    private boolean matchDispatcherType(DispatcherType dispatcherType) {
        return this.dispatcherTypes == null || this.dispatcherTypes.stream().anyMatch(type -> type == dispatcherType);
    }

    private boolean matchRequestPath(String requestPath) {
        if (!this.hasPatterns) {
            return true;
        }
        for (String pattern : this.exactMatches) {
            if (!pattern.equals(requestPath)) continue;
            return true;
        }
        if (!requestPath.startsWith("/")) {
            return false;
        }
        for (String pattern : this.endsWithMatches) {
            if (!requestPath.endsWith(pattern)) continue;
            return true;
        }
        for (String pattern : this.startsWithMatches) {
            if (!requestPath.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.delegate.init(filterConfig);
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public void initIfRequired(@Nullable ServletContext servletContext) throws ServletException {
        if (this.filterConfigInitializer != null) {
            FilterConfig filterConfig = this.filterConfigInitializer.apply(servletContext);
            this.delegate.init(filterConfig);
        }
    }
}

