/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseExpression
implements JRExpression,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected int id;
    private JRExpressionChunk[] chunks;
    private static int lastId;
    protected ExpressionTypeEnum type;

    protected JRBaseExpression() {
    }

    protected JRBaseExpression(JRExpression expression, JRBaseObjectFactory factory, Integer expressionId) {
        factory.put(expression, this);
        this.id = expressionId == null ? expression.getId() : expressionId.intValue();
        this.type = expression.getType();
        JRExpressionChunk[] jrChunks = expression.getChunks();
        if (jrChunks != null && jrChunks.length > 0) {
            this.chunks = new JRExpressionChunk[jrChunks.length];
            for (int i = 0; i < this.chunks.length; ++i) {
                this.chunks[i] = factory.getExpressionChunk(jrChunks[i]);
            }
        }
    }

    protected JRBaseExpression(JRExpression expression, JRBaseObjectFactory factory) {
        this(expression, factory, null);
    }

    private static synchronized int getNextId() {
        return lastId++;
    }

    public void regenerateId() {
        this.id = JRBaseExpression.getNextId();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public ExpressionTypeEnum getType() {
        return this.type;
    }

    @Override
    public JRExpressionChunk[] getChunks() {
        return this.chunks;
    }

    @Override
    public String getText() {
        String text = "";
        this.chunks = this.getChunks();
        if (this.chunks != null && this.chunks.length > 0) {
            StringBuilder sb = new StringBuilder();
            block6: for (int i = 0; i < this.chunks.length; ++i) {
                switch (this.chunks[i].getType()) {
                    case 2: {
                        sb.append("$P{");
                        sb.append(this.chunks[i].getText());
                        sb.append("}");
                        continue block6;
                    }
                    case 3: {
                        sb.append("$F{");
                        sb.append(this.chunks[i].getText());
                        sb.append("}");
                        continue block6;
                    }
                    case 4: {
                        sb.append("$V{");
                        sb.append(this.chunks[i].getText());
                        sb.append("}");
                        continue block6;
                    }
                    case 5: {
                        sb.append("$R{");
                        sb.append(this.chunks[i].getText());
                        sb.append("}");
                        continue block6;
                    }
                    default: {
                        String textChunk = this.chunks[i].getText();
                        String escapedText = this.escapeTextChunk(textChunk);
                        sb.append(escapedText);
                        continue block6;
                    }
                }
            }
            text = sb.toString();
        }
        return text;
    }

    protected String escapeTextChunk(String text) {
        if (text == null || text.indexOf(36) < 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length() + 4);
        StringTokenizer tkzer = new StringTokenizer(text, "$", true);
        boolean wasDelim = false;
        while (tkzer.hasMoreElements()) {
            String token = tkzer.nextToken();
            if (wasDelim && (token.startsWith("P{") || token.startsWith("F{") || token.startsWith("V{") || token.startsWith("R{")) && token.indexOf(125) > 0) {
                sb.append('$');
            }
            sb.append(token);
            wasDelim = token.equals("$");
        }
        return sb.toString();
    }

    @Override
    public Object clone() {
        JRBaseExpression clone = null;
        try {
            clone = (JRBaseExpression)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.chunks = (JRExpressionChunk[])JRCloneUtils.cloneArray((JRCloneable[])this.chunks);
        return clone;
    }
}

