/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.components.table.BaseCell;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.ColumnFactory;
import net.sf.jasperreports.components.table.GroupRow;
import net.sf.jasperreports.components.table.Row;
import net.sf.jasperreports.components.table.RowFactory;
import net.sf.jasperreports.components.table.StandardGroupRow;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.WhenNoDataTypeTableEnum;
import net.sf.jasperreports.components.table.util.ColumnElementsVisitor;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.HorizontalPosition;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardTable
implements TableComponent,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DATASET_RUN = "datasetRun";
    public static final String PROPERTY_COLUMNS = "columns";
    public static final String PROPERTY_WHEN_NO_DATA_TYPE = "whenNoDataType";
    public static final String PROPERTY_HORIZONTAL_POSITION = "horizontalPosition";
    public static final String PROPERTY_SHRINK_WIDTH = "shrinkWidth";
    public static final String PROPERTY_TABLE_HEADER = "tableHeader";
    public static final String PROPERTY_TABLE_FOOTER = "tableFooter";
    public static final String PROPERTY_COLUMN_HEADER = "columnHeader";
    public static final String PROPERTY_COLUMN_FOOTER = "columnFooter";
    public static final String PROPERTY_GROUP_HEADERS = "groupHeaders";
    public static final String PROPERTY_GROUP_FOOTERS = "groupFooters";
    public static final String PROPERTY_DETAIL = "detail";
    public static final String PROPERTY_NO_DATA = "noData";
    private JRDatasetRun datasetRun;
    private List<BaseColumn> columns;
    private WhenNoDataTypeTableEnum whenNoDataType;
    private HorizontalPosition horizontalPosition;
    private Boolean shrinkWidth;
    private Row tableHeader;
    private Row tableFooter;
    private List<GroupRow> groupHeaders;
    private List<GroupRow> groupFooters;
    private Row columnHeader;
    private Row columnFooter;
    private Row detail;
    private BaseCell noData;
    private transient JRPropertyChangeSupport eventSupport;

    public StandardTable() {
        this.columns = new ArrayList<BaseColumn>();
    }

    public StandardTable(TableComponent table, JRBaseObjectFactory factory) {
        this.whenNoDataType = table.getWhenNoDataType();
        this.horizontalPosition = table.getHorizontalPosition();
        this.shrinkWidth = table.shrinkWidth();
        this.datasetRun = factory.getDatasetRun(table.getDatasetRun());
        ColumnFactory columnFactory = new ColumnFactory(factory);
        this.columns = columnFactory.createColumns(table.getColumns());
        RowFactory rowFactory = new RowFactory(factory);
        this.tableHeader = rowFactory.createRow(table.getTableHeader());
        this.tableFooter = rowFactory.createRow(table.getTableFooter());
        this.groupHeaders = rowFactory.createGroupRows(table.getGroupHeaders());
        this.groupFooters = rowFactory.createGroupRows(table.getGroupFooters());
        this.columnHeader = rowFactory.createRow(table.getColumnHeader());
        this.columnFooter = rowFactory.createRow(table.getColumnFooter());
        this.detail = rowFactory.createRow(table.getDetail());
        this.noData = rowFactory.createBaseCell(table.getNoData());
    }

    @Override
    public List<BaseColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<BaseColumn> columns) {
        List<BaseColumn> old = this.columns;
        this.columns = columns;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMNS, old, this.columns);
    }

    public void addColumn(BaseColumn column) {
        this.columns.add(column);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMNS, column, this.columns.size() - 1);
    }

    public void addColumn(int index, BaseColumn column) {
        this.columns.add(index, column);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMNS, column, index);
    }

    public boolean removeColumn(BaseColumn column) {
        int idx = this.columns.indexOf(column);
        if (idx >= 0) {
            this.columns.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_COLUMNS, column, idx);
        }
        return idx >= 0;
    }

    @Override
    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    public void setDatasetRun(JRDatasetRun datasetRun) {
        JRDatasetRun old = this.datasetRun;
        this.datasetRun = datasetRun;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET_RUN, old, this.datasetRun);
    }

    @Override
    public WhenNoDataTypeTableEnum getWhenNoDataType() {
        return this.whenNoDataType;
    }

    public void setWhenNoDataType(WhenNoDataTypeTableEnum whenNoDataType) {
        WhenNoDataTypeTableEnum old = this.whenNoDataType;
        this.whenNoDataType = whenNoDataType;
        this.getEventSupport().firePropertyChange(PROPERTY_WHEN_NO_DATA_TYPE, old, this.whenNoDataType);
    }

    @Override
    public HorizontalPosition getHorizontalPosition() {
        return this.horizontalPosition;
    }

    public void setHorizontalPosition(HorizontalPosition horizontalPosition) {
        HorizontalPosition old = this.horizontalPosition;
        this.horizontalPosition = horizontalPosition;
        this.getEventSupport().firePropertyChange(PROPERTY_HORIZONTAL_POSITION, old, this.horizontalPosition);
    }

    @Override
    public Boolean shrinkWidth() {
        return this.shrinkWidth;
    }

    public void setShrinkWidth(Boolean shrinkWidth) {
        Boolean old = this.shrinkWidth;
        this.shrinkWidth = shrinkWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_SHRINK_WIDTH, old, this.shrinkWidth);
    }

    @Override
    public Row getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(Row tableHeader) {
        Row old = this.tableHeader;
        this.tableHeader = tableHeader;
        this.getEventSupport().firePropertyChange(PROPERTY_TABLE_HEADER, old, this.tableHeader);
    }

    @Override
    public Row getTableFooter() {
        return this.tableFooter;
    }

    public void setTableFooter(Row tableFooter) {
        Row old = this.tableFooter;
        this.tableFooter = tableFooter;
        this.getEventSupport().firePropertyChange(PROPERTY_TABLE_FOOTER, old, this.tableFooter);
    }

    @Override
    public List<GroupRow> getGroupHeaders() {
        return this.groupHeaders;
    }

    @Override
    public List<GroupRow> getGroupFooters() {
        return this.groupFooters;
    }

    protected int findGroupRowIndex(List<GroupRow> groupRows, String groupName) {
        int idx = -1;
        if (groupRows != null) {
            ListIterator<GroupRow> it = groupRows.listIterator();
            while (it.hasNext()) {
                GroupRow groupRow = it.next();
                if (!groupName.equals(groupRow.getGroupName())) continue;
                idx = it.previousIndex();
            }
        }
        return idx;
    }

    @Override
    public Row getGroupFooter(String groupName) {
        int idx = this.findGroupRowIndex(this.groupFooters, groupName);
        return idx < 0 ? null : this.groupFooters.get(idx).getRow();
    }

    @Override
    public Row getGroupHeader(String groupName) {
        int idx = this.findGroupRowIndex(this.groupHeaders, groupName);
        return idx < 0 ? null : this.groupHeaders.get(idx).getRow();
    }

    public void setGroupHeaders(List<GroupRow> groupHeaders) {
        List<GroupRow> old = this.groupHeaders;
        this.groupHeaders = groupHeaders;
        this.getEventSupport().firePropertyChange(PROPERTY_GROUP_HEADERS, old, this.groupHeaders);
    }

    public void setGroupFooters(List<GroupRow> groupFooters) {
        List<GroupRow> old = this.groupFooters;
        this.groupFooters = groupFooters;
        this.getEventSupport().firePropertyChange(PROPERTY_GROUP_FOOTERS, old, this.groupFooters);
    }

    public void addGroupHeader(GroupRow groupRow) {
        if (this.groupHeaders == null) {
            this.groupHeaders = new ArrayList<GroupRow>();
        }
        this.groupHeaders.add(groupRow);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_GROUP_HEADERS, groupRow, this.groupHeaders.size() - 1);
    }

    public void addGroupFooter(GroupRow groupRow) {
        if (this.groupFooters == null) {
            this.groupFooters = new ArrayList<GroupRow>();
        }
        this.groupFooters.add(groupRow);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_GROUP_FOOTERS, groupRow, this.groupFooters.size() - 1);
    }

    public boolean removeGroupFooter(GroupRow groupRow) {
        if (this.groupFooters == null) {
            return false;
        }
        int idx = this.groupFooters.indexOf(groupRow);
        if (idx >= 0) {
            this.groupFooters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_GROUP_FOOTERS, groupRow, idx);
        }
        return idx >= 0;
    }

    public boolean removeGroupHeader(GroupRow groupRow) {
        if (this.groupHeaders == null) {
            return false;
        }
        int idx = this.groupHeaders.indexOf(groupRow);
        if (idx >= 0) {
            this.groupHeaders.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_GROUP_HEADERS, groupRow, idx);
        }
        return idx >= 0;
    }

    public void setGroupFooter(String groupName, Row row) {
        int idx = this.findGroupRowIndex(this.groupFooters, groupName);
        if (idx >= 0) {
            GroupRow old = this.groupFooters.get(idx);
            if (row == null) {
                this.groupFooters.remove(idx);
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_GROUP_FOOTERS, old, idx);
            } else {
                StandardGroupRow groupRow = new StandardGroupRow(groupName, row);
                this.groupFooters.set(idx, groupRow);
                this.getEventSupport().fireIndexedPropertyChange(PROPERTY_GROUP_FOOTERS, idx, old, groupRow);
            }
        } else if (row != null) {
            StandardGroupRow groupRow = new StandardGroupRow(groupName, row);
            this.addGroupFooter(groupRow);
        }
    }

    public void setGroupHeader(String groupName, Row row) {
        int idx = this.findGroupRowIndex(this.groupHeaders, groupName);
        if (idx >= 0) {
            GroupRow old = this.groupHeaders.get(idx);
            if (row == null) {
                this.groupHeaders.remove(idx);
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_GROUP_HEADERS, old, idx);
            } else {
                StandardGroupRow groupRow = new StandardGroupRow(groupName, row);
                this.groupHeaders.set(idx, groupRow);
                this.getEventSupport().fireIndexedPropertyChange(PROPERTY_GROUP_HEADERS, idx, old, groupRow);
            }
        } else if (row != null) {
            StandardGroupRow groupRow = new StandardGroupRow(groupName, row);
            this.addGroupHeader(groupRow);
        }
    }

    @Override
    public Row getColumnHeader() {
        return this.columnHeader;
    }

    public void setColumnHeader(Row header) {
        Row old = this.columnHeader;
        this.columnHeader = header;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_HEADER, old, this.columnHeader);
    }

    @Override
    public Row getColumnFooter() {
        return this.columnFooter;
    }

    public void setColumnFooter(Row header) {
        Row old = this.columnFooter;
        this.columnFooter = header;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_FOOTER, old, this.columnFooter);
    }

    @Override
    public Row getDetail() {
        return this.detail;
    }

    public void setDetail(Row detail) {
        Row old = this.detail;
        this.detail = detail;
        this.getEventSupport().firePropertyChange(PROPERTY_DETAIL, old, this.detail);
    }

    @Override
    public BaseCell getNoData() {
        return this.noData;
    }

    public void setNoData(BaseCell noData) {
        BaseCell old = this.noData;
        this.noData = noData;
        this.getEventSupport().firePropertyChange(PROPERTY_NO_DATA, old, this.noData);
    }

    @Override
    public Object clone() {
        StandardTable clone = null;
        try {
            clone = (StandardTable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.datasetRun = JRCloneUtils.nullSafeClone(this.datasetRun);
        clone.columns = JRCloneUtils.cloneList(this.columns);
        clone.tableHeader = JRCloneUtils.nullSafeClone(this.tableHeader);
        clone.tableFooter = JRCloneUtils.nullSafeClone(this.tableFooter);
        clone.groupHeaders = JRCloneUtils.cloneList(this.groupHeaders);
        clone.groupFooters = JRCloneUtils.cloneList(this.groupFooters);
        clone.columnHeader = JRCloneUtils.nullSafeClone(this.columnHeader);
        clone.columnFooter = JRCloneUtils.nullSafeClone(this.columnFooter);
        clone.detail = JRCloneUtils.nullSafeClone(this.detail);
        clone.noData = JRCloneUtils.nullSafeClone(this.noData);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardTable standardTable = this;
        synchronized (standardTable) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public void visit(JRVisitor visitor) {
        if (ElementsVisitorUtils.visitDeepElements(visitor)) {
            ColumnElementsVisitor columnElementsVisitor = new ColumnElementsVisitor(visitor);
            for (BaseColumn column : this.columns) {
                column.visitColumn(columnElementsVisitor);
            }
        }
    }
}

