/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.web.util;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.api.AttributeContext;
import org.apache.tiles.api.TilesContainer;
import org.apache.tiles.api.access.TilesAccess;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.reflect.ClassUtil;
import org.apache.tiles.request.servlet.ServletUtil;
import org.apache.tiles.web.util.AttributeContextMutator;

public class TilesDispatchServlet
extends HttpServlet {
    public static final String CONTAINER_KEY_INIT_PARAMETER = "org.apache.tiles.web.util.TilesDispatchServlet.CONTAINER_KEY";
    private static final Logger LOG = LogManager.getLogger(TilesDispatchServlet.class);
    private String containerKey;
    private AttributeContextMutator mutator;

    public void init() throws ServletException {
        super.init();
        this.containerKey = this.getServletConfig().getInitParameter(CONTAINER_KEY_INIT_PARAMETER);
        String temp = this.getInitParameter("mutator");
        if (temp != null) {
            try {
                this.mutator = (AttributeContextMutator)ClassUtil.instantiate(temp);
            }
            catch (Exception e) {
                throw new ServletException("Unable to instantiate specified context mutator.", (Throwable)e);
            }
        } else {
            this.mutator = new DefaultMutator();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        ApplicationContext applicationContext = ServletUtil.getApplicationContext(this.getServletContext());
        org.apache.tiles.request.servlet.ServletRequest request = new org.apache.tiles.request.servlet.ServletRequest(applicationContext, req, res);
        TilesContainer container = TilesAccess.getContainer(applicationContext, this.containerKey);
        this.mutator.mutate(container.getAttributeContext(request), (ServletRequest)req);
        String definition = this.getDefinitionName(req);
        if (LOG.isDebugEnabled()) {
            LOG.info("Dispatching to tile '{}'", (Object)definition);
        }
        container.render(definition, (Request)request);
    }

    protected String getDefinitionName(HttpServletRequest request) {
        String path = (String)request.getAttribute("jakarta.servlet.include.servlet_path");
        if (path == null) {
            path = request.getServletPath();
        }
        int start = path.startsWith("/") ? 1 : 0;
        int end = path.endsWith(".tiles") ? path.indexOf(".tiles") : path.length();
        return path.substring(start, end);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        LOG.info("Tiles dispatch request received. Redirecting POST to GET.");
        this.doGet(req, res);
    }

    static class DefaultMutator
    implements AttributeContextMutator {
        DefaultMutator() {
        }

        @Override
        public void mutate(AttributeContext context, ServletRequest request) {
        }
    }
}

