/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileUploadFileCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletDiskFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.LocalizedMessage;
import org.apache.struts2.dispatcher.multipart.AbstractMultiPartRequest;
import org.apache.struts2.dispatcher.multipart.StrutsUploadedFile;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class JakartaStreamMultiPartRequest
extends AbstractMultiPartRequest {
    private static final Logger LOG = LogManager.getLogger(JakartaStreamMultiPartRequest.class);

    @Override
    protected void processUpload(HttpServletRequest request, String saveDir) throws IOException {
        Charset charset = this.readCharsetEncoding(request);
        Path location = Path.of(saveDir, new String[0]);
        JakartaServletDiskFileUpload servletFileUpload = this.prepareServletFileUpload(charset, location);
        LOG.debug("Using Jakarta Stream API to process request");
        servletFileUpload.getItemIterator(request).forEachRemaining(item -> {
            if (item.isFormField()) {
                LOG.debug(() -> "Processing a form field: " + StringUtils.normalizeSpace((String)item.getFieldName()));
                this.processFileItemAsFormField((FileItemInput)item);
            } else {
                LOG.debug(() -> "Processing a file: " + StringUtils.normalizeSpace((String)item.getFieldName()));
                this.processFileItemAsFileField((FileItemInput)item, location);
            }
        });
    }

    private String readStream(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String string = result.toString(StandardCharsets.UTF_8);
            return string;
        }
    }

    protected void processFileItemAsFormField(FileItemInput fileItemInput) throws IOException {
        String fieldName = fileItemInput.getFieldName();
        if (fieldName == null) {
            LOG.warn("Form field has null fieldName, skipping");
            return;
        }
        String fieldValue = this.readStream(fileItemInput.getInputStream());
        if (this.exceedsMaxStringLength(fieldName, fieldValue)) {
            return;
        }
        List values = this.parameters.computeIfAbsent(fieldName, k -> new ArrayList());
        values.add(fieldValue);
    }

    protected Long actualSizeOfUploadedFiles() {
        return this.uploadedFiles.values().stream().map(files -> files.stream().map(UploadedFile::length).reduce(0L, Long::sum)).reduce(0L, Long::sum);
    }

    private boolean exceedsMaxFiles(FileItemInput fileItemInput) {
        if (this.maxFiles != null && this.maxFiles == (long)this.uploadedFiles.size()) {
            LocalizedMessage errorMessage;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot accept another file: {} as it will exceed max files: {}", (Object)StringUtils.normalizeSpace((String)fileItemInput.getName()), (Object)this.maxFiles);
            }
            if (!this.errors.contains(errorMessage = this.buildErrorMessage(FileUploadFileCountLimitException.class, String.format("File %s exceeds allowed maximum number of files %s", fileItemInput.getName(), this.maxFiles), new Object[]{this.maxFiles, this.uploadedFiles.size()}))) {
                this.errors.add(errorMessage);
            }
            return true;
        }
        return false;
    }

    private void exceedsMaxSizeOfFiles(FileItemInput fileItemInput, File file, Long currentFilesSize) {
        LocalizedMessage errorMessage;
        if (LOG.isDebugEnabled()) {
            LOG.debug("File: {} of size: {} exceeds allowed max size: {}, actual size of already uploaded files: {}", (Object)StringUtils.normalizeSpace((String)fileItemInput.getName()), (Object)file.length(), (Object)this.maxSizeOfFiles, (Object)currentFilesSize);
        }
        if (!this.errors.contains(errorMessage = this.buildErrorMessage(FileUploadSizeException.class, String.format("Size %s of file %s exceeds allowed max size %s", file.length(), fileItemInput.getName(), this.maxSizeOfFiles), new Object[]{this.maxSizeOfFiles, currentFilesSize}))) {
            this.errors.add(errorMessage);
        }
        if (!file.delete() && LOG.isWarnEnabled()) {
            LOG.warn("Cannot delete file: {} which exceeds maximum size: {} of all files!", (Object)StringUtils.normalizeSpace((String)fileItemInput.getName()), (Object)this.maxSizeOfFiles);
        }
    }

    protected void processFileItemAsFileField(FileItemInput fileItemInput, Path location) throws IOException {
        Long currentFilesSize;
        if (fileItemInput.getName() == null || fileItemInput.getName().trim().isEmpty()) {
            LOG.debug(() -> "No file has been uploaded for the field: " + StringUtils.normalizeSpace((String)fileItemInput.getFieldName()));
            return;
        }
        if (fileItemInput.getFieldName() == null) {
            LOG.warn("File upload has null fieldName, skipping");
            return;
        }
        if (this.exceedsMaxFiles(fileItemInput)) {
            return;
        }
        File file = this.createTemporaryFile(fileItemInput.getName(), location);
        this.streamFileToDisk(fileItemInput, file);
        if (this.rejectEmptyFile(file.length(), fileItemInput.getName(), fileItemInput.getFieldName())) {
            this.deleteFile(file.toPath());
            return;
        }
        Long l = currentFilesSize = this.maxSizeOfFiles != null ? this.actualSizeOfUploadedFiles() : null;
        if (this.maxSizeOfFiles != null && currentFilesSize + file.length() >= this.maxSizeOfFiles) {
            this.exceedsMaxSizeOfFiles(fileItemInput, file, currentFilesSize);
        } else {
            this.createUploadedFile(fileItemInput, file);
        }
    }

    protected void streamFileToDisk(FileItemInput fileItemInput, File file) throws IOException {
        InputStream input = fileItemInput.getInputStream();
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]), this.bufferSize);){
            int length;
            byte[] buffer = new byte[this.bufferSize];
            LOG.debug("Streaming file: {} using buffer size: {}", (Object)StringUtils.normalizeSpace((String)fileItemInput.getName()), (Object)this.bufferSize);
            while ((length = input.read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, length);
            }
        }
    }

    protected void createUploadedFile(FileItemInput fileItemInput, File file) {
        String fileName = fileItemInput.getName();
        String fieldName = fileItemInput.getFieldName();
        UploadedFile uploadedFile = StrutsUploadedFile.Builder.create(file).withOriginalName(fileName).withContentType(fileItemInput.getContentType()).withInputName(fieldName).build();
        List infos = this.uploadedFiles.computeIfAbsent(fieldName, key -> new ArrayList());
        infos.add(uploadedFile);
    }
}

