/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import net.sf.oval.internal.Log;

public final class SerializableConstructor
implements Serializable {
    private static final Log LOG = Log.getLog(SerializableConstructor.class);
    private static final long serialVersionUID = 1L;
    private transient Constructor<?> constructor;
    private final Class<?> declaringClass;
    private final Class<?>[] parameterTypes;

    public SerializableConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
        this.parameterTypes = constructor.getParameterTypes();
        this.declaringClass = constructor.getDeclaringClass();
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.constructor = this.declaringClass.getDeclaredConstructor(this.parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            LOG.debug("Unexpected NoSuchMethodException occurred", ex);
            throw new IOException(ex.getMessage());
        }
    }
}

