/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.namequeues.MetricsWALEventTrackerSource;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsWALEventTrackerSourceImpl
extends BaseSourceImpl
implements MetricsWALEventTrackerSource {
    private final MutableFastCounter numFailedPutsCount = this.getMetricsRegistry().newCounter("numFailedPuts", "Number of put requests that failed", 0L);
    private final MutableFastCounter numRecordsFailedPutsCount = this.getMetricsRegistry().newCounter("numRecordsFailedPuts", "number of records in failed puts", 0L);

    public MetricsWALEventTrackerSourceImpl() {
        this("WALEventTracker", "Metrics about HBase RegionServer WALEventTracker", "regionserver", "RegionServer,sub=WALEventTracker");
    }

    public MetricsWALEventTrackerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    public void incrFailedPuts(long numRecords) {
        this.numFailedPutsCount.incr();
        this.numRecordsFailedPutsCount.incr(numRecords);
    }

    public long getFailedPuts() {
        return this.numFailedPutsCount.value();
    }

    public long getNumRecordsFailedPuts() {
        return this.numRecordsFailedPutsCount.value();
    }
}

