/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.workertoken;

import java.security.AccessController;
import java.util.Base64;
import javax.security.auth.Subject;
import org.apache.storm.generated.WorkerToken;
import org.apache.storm.generated.WorkerTokenServiceType;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.security.auth.sasl.SimpleSaslClientCallbackHandler;

public class WorkerTokenClientCallbackHandler
extends SimpleSaslClientCallbackHandler {
    public WorkerTokenClientCallbackHandler(WorkerToken token) {
        super(Base64.getEncoder().encodeToString(token.get_info()), Base64.getEncoder().encodeToString(token.get_signature()));
    }

    public static WorkerToken findWorkerTokenInSubject(ThriftConnectionType type) {
        Subject subject;
        WorkerTokenServiceType serviceType = type.getWtType();
        WorkerToken ret = null;
        if (serviceType != null && (subject = Subject.getSubject(AccessController.getContext())) != null) {
            ret = ClientAuthUtils.findWorkerToken(subject, serviceType);
        }
        return ret;
    }
}

