/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.jute;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.storm.shade.org.apache.jute.Index;
import org.apache.storm.shade.org.apache.jute.InputArchive;
import org.apache.storm.shade.org.apache.jute.Record;

public class BinaryInputArchive
implements InputArchive {
    public static final String UNREASONBLE_LENGTH = "Unreasonable length = ";
    public static final int maxBuffer = Integer.getInteger("jute.maxbuffer", 1048575);
    private static final int extraMaxBuffer;
    private final DataInput in;
    private final int totalBufferSize;

    public static BinaryInputArchive getArchive(InputStream stream) {
        return new BinaryInputArchive(new DataInputStream(stream));
    }

    public BinaryInputArchive(DataInput in) {
        this(in, maxBuffer, extraMaxBuffer);
    }

    public BinaryInputArchive(DataInput in, int maxBufferSize, int extraMaxBufferSize) {
        this.in = in;
        this.totalBufferSize = (long)maxBufferSize + (long)extraMaxBufferSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : maxBufferSize + extraMaxBufferSize;
    }

    @Override
    public byte readByte(String tag) throws IOException {
        return this.in.readByte();
    }

    @Override
    public boolean readBool(String tag) throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public int readInt(String tag) throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong(String tag) throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat(String tag) throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble(String tag) throws IOException {
        return this.in.readDouble();
    }

    @Override
    public String readString(String tag) throws IOException {
        int len = this.in.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLength(len);
        byte[] b = new byte[len];
        this.in.readFully(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] readBuffer(String tag) throws IOException {
        int len = this.readInt(tag);
        if (len == -1) {
            return null;
        }
        this.checkLength(len);
        byte[] arr = new byte[len];
        this.in.readFully(arr);
        return arr;
    }

    @Override
    public void readRecord(Record r, String tag) throws IOException {
        r.deserialize(this, tag);
    }

    @Override
    public void startRecord(String tag) throws IOException {
    }

    @Override
    public void endRecord(String tag) throws IOException {
    }

    @Override
    public Index startVector(String tag) throws IOException {
        int len = this.readInt(tag);
        if (len == -1) {
            return null;
        }
        return new BinaryIndex(len);
    }

    @Override
    public void endVector(String tag) throws IOException {
    }

    @Override
    public Index startMap(String tag) throws IOException {
        return new BinaryIndex(this.readInt(tag));
    }

    @Override
    public void endMap(String tag) throws IOException {
    }

    private void checkLength(int len) throws IOException {
        if (len < 0 || len > this.totalBufferSize) {
            throw new IOException(UNREASONBLE_LENGTH + len);
        }
    }

    static {
        Integer configuredExtraMaxBuffer = Integer.getInteger("zookeeper.jute.maxbuffer.extrasize", maxBuffer);
        extraMaxBuffer = configuredExtraMaxBuffer < 1024 ? 1024 : configuredExtraMaxBuffer;
    }

    private static class BinaryIndex
    implements Index {
        private int n;

        BinaryIndex(int nelems) {
            this.n = nelems;
        }

        @Override
        public boolean done() {
            return this.n <= 0;
        }

        @Override
        public void incr() {
            --this.n;
        }
    }
}

