/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import org.apache.sling.jcr.contentparser.impl.JsonTicksConverter;

public class JsonUtil {
    private JsonUtil() {
    }

    public static JsonStructure parse(String input) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(JsonTicksConverter.tickToDoubleQuote(input)));){
            JsonStructure jsonStructure = reader.read();
            return jsonStructure;
        }
    }

    public static JsonObject parseObject(String input) {
        return (JsonObject)JsonUtil.parse(input);
    }

    public static JsonArray parseArray(String input) {
        return (JsonArray)JsonUtil.parse(input);
    }

    public static Object unbox(JsonValue value, Function<JsonStructure, Object> convert) {
        switch (value.getValueType()) {
            case ARRAY: 
            case OBJECT: {
                return convert.apply((JsonStructure)value);
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case NULL: {
                return null;
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)value;
                return number.isIntegral() ? (double)number.longValue() : number.doubleValue();
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
        }
        throw new JsonException("Unknow value type");
    }

    public static <T> T unbox(JsonValue value) {
        return (T)JsonUtil.unbox(value, json -> json.getValueType() == JsonValue.ValueType.ARRAY ? ((JsonArray)json).stream().map(JsonUtil::unbox).collect(Collectors.toList()) : ((JsonObject)json).entrySet().stream().map(entry -> new AbstractMap.SimpleEntry((String)entry.getKey(), JsonUtil.unbox((JsonValue)entry.getValue()))).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public static String toString(JsonValue value) {
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = Json.createGenerator((Writer)writer);){
            generator.write(value);
        }
        return writer.toString();
    }

    public static String toString(JsonArrayBuilder builder) {
        return JsonUtil.toString((JsonValue)builder.build());
    }

    public static String toString(JsonObjectBuilder builder) {
        return JsonUtil.toString((JsonValue)builder.build());
    }
}

