/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.serviceusermapping.ServicePrincipalsValidator;
import org.apache.sling.serviceusermapping.ServiceUserValidator;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(service={ServiceUserValidator.class, ServicePrincipalsValidator.class}, property={"service.vendor=The Apache Software Foundation"})
public class JcrSystemUserValidator
implements ServiceUserValidator,
ServicePrincipalsValidator {
    public static final String VALIDATION_SERVICE_USER = "validation";
    private final Logger log = LoggerFactory.getLogger(JcrSystemUserValidator.class);
    @Reference
    private volatile SlingRepository repository;
    private final Method isSystemUserMethod;
    private final Set<String> validIds = new CopyOnWriteArraySet<String>();
    private final Set<String> validPrincipalNames = new CopyOnWriteArraySet<String>();
    private boolean allowOnlySystemUsers;
    private final ThreadLocal<Boolean> cycleDetection = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public JcrSystemUserValidator() {
        Method m = null;
        try {
            m = User.class.getMethod("isSystemUser", new Class[0]);
        }
        catch (Exception e) {
            this.log.debug("Exception while accessing isSystemUser method", (Throwable)e);
        }
        this.isSystemUserMethod = m;
    }

    @Activate
    public void activate(Config config) {
        this.allowOnlySystemUsers = config.allow_only_system_user();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(String serviceUserId, String serviceName, String subServiceName) {
        block13: {
            boolean bl;
            if (this.cycleDetection.get().booleanValue()) {
                return true;
            }
            if (serviceUserId == null) {
                this.log.debug("The provided service user id is null");
                return false;
            }
            if (!this.allowOnlySystemUsers) {
                this.log.debug("There is no enforcement of JCR system users, therefore service user id '{}' is valid", (Object)serviceUserId);
                return true;
            }
            if (this.validIds.contains(serviceUserId)) {
                this.log.debug("The provided service user id '{}' has been already validated and is a known JCR system user id", (Object)serviceUserId);
                return true;
            }
            Session session = null;
            try {
                UserManager userManager;
                Authorizable authorizable;
                this.cycleDetection.set(true);
                try {
                    session = this.repository.loginService(VALIDATION_SERVICE_USER, null);
                }
                finally {
                    this.cycleDetection.set(false);
                }
                if (!(session instanceof JackrabbitSession) || !this.isValidSystemUser(authorizable = (userManager = ((JackrabbitSession)session).getUserManager()).getAuthorizable(serviceUserId))) break block13;
                this.validIds.add(serviceUserId);
                this.log.debug("The provided service user id {} is a known JCR system user id", (Object)serviceUserId);
                bl = true;
                if (session == null) return bl;
            }
            catch (RepositoryException e) {
                this.log.warn("Could not get user information", (Throwable)e);
                break block13;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            session.logout();
            return bl;
        }
        this.log.warn("The provided service user id '{}' is not a known JCR system user id and therefore not allowed in the Sling Service User Mapper.", (Object)serviceUserId);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(Iterable<String> servicePrincipalNames, String serviceName, String subServiceName) {
        if (this.cycleDetection.get().booleanValue()) {
            return true;
        }
        if (servicePrincipalNames == null) {
            this.log.debug("The provided service principal names are null");
            return false;
        }
        if (!this.allowOnlySystemUsers) {
            this.log.debug("There is no enforcement of JCR system users, therefore service principal names '{}' are valid", servicePrincipalNames);
            return true;
        }
        Session session = null;
        UserManager userManager = null;
        HashSet<String> invalid = new HashSet<String>();
        try {
            for (String pName : servicePrincipalNames) {
                Authorizable authorizable;
                if (this.validPrincipalNames.contains(pName)) {
                    this.log.debug("The provided service principal name '{}' has been already validated and is a known JCR system user", (Object)pName);
                    continue;
                }
                if (session == null) {
                    this.cycleDetection.set(true);
                    try {
                        session = this.repository.loginService(VALIDATION_SERVICE_USER, null);
                    }
                    finally {
                        this.cycleDetection.set(false);
                    }
                    if (session instanceof JackrabbitSession) {
                        userManager = ((JackrabbitSession)session).getUserManager();
                    } else {
                        this.log.debug("Unable to validate service user principals, JackrabbitSession expected.");
                        boolean bl = false;
                        return bl;
                    }
                }
                if (this.isValidSystemUser(authorizable = userManager.getAuthorizable(() -> pName))) {
                    this.validPrincipalNames.add(pName);
                    this.log.debug("The provided service principal name {} is a known JCR system user", (Object)pName);
                    continue;
                }
                this.log.warn("The provided service principal name '{}' is not a known JCR system user id and therefore not allowed in the Sling Service User Mapper.", (Object)pName);
                invalid.add(pName);
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Could not get user information", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return invalid.isEmpty();
    }

    private boolean isValidSystemUser(Authorizable authorizable) {
        if (authorizable == null || authorizable.isGroup()) {
            return false;
        }
        User user = (User)authorizable;
        try {
            if (!user.isDisabled()) {
                if (this.isSystemUserMethod != null) {
                    try {
                        return (Boolean)this.isSystemUserMethod.invoke((Object)user, new Object[0]);
                    }
                    catch (Exception e) {
                        this.log.debug("Exception while invoking isSystemUser method", (Throwable)e);
                        return true;
                    }
                }
                return true;
            }
        }
        catch (RepositoryException e) {
            this.log.debug("Exception while invoking isDisabled method", (Throwable)e);
        }
        return false;
    }

    @ObjectClassDefinition(name="Apache Sling JCR System User Validator", description="Enforces the usage of JCR system users for all user mappings being used in the 'Sling Service User Mapper Service'")
    public static @interface Config {
        @AttributeDefinition(name="Allow only JCR System Users", description="If set to true, only user IDs bound to JCR system users are allowed in the user mappings of the 'Sling Service User Mapper Service'. Otherwise all users are allowed!")
        public boolean allow_only_system_user() default true;
    }
}

