/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation.timeout;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.invocation.InvocationTimeoutStrategy;

public class PassingTimeStrategy
implements InvocationTimeoutStrategy {
    public static final String NAME = "passing-time";
    public static final String CHAIN_START_TIME = "x-scb-chain-start";
    private Clock clock = Clock.systemDefaultZone();

    public PassingTimeStrategy setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void start(Invocation invocation) {
        if (invocation.getLocalContext(CHAIN_START_TIME) != null) {
            return;
        }
        long startTimeMillis = invocation.getInvocationStageTrace().getStartInMillis();
        String contextChainStartTime = invocation.getContext(CHAIN_START_TIME);
        if (StringUtils.isEmpty((CharSequence)contextChainStartTime)) {
            invocation.addContext(CHAIN_START_TIME, String.valueOf(startTimeMillis));
            invocation.addLocalContext(CHAIN_START_TIME, startTimeMillis);
            return;
        }
        long chainStartTime = NumberUtils.toLong((String)contextChainStartTime, (long)startTimeMillis);
        invocation.addLocalContext(CHAIN_START_TIME, chainStartTime);
    }

    @Override
    public long calculateElapsedNanoTime(Invocation invocation) {
        long passingTimeMillis = this.clock.millis() - (Long)invocation.getLocalContext(CHAIN_START_TIME);
        return TimeUnit.MILLISECONDS.toNanos(passingTimeMillis);
    }
}

