/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.ContextUtils;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class ProviderOperationFilter
extends AbstractFilter
implements ProviderFilter {
    public static final String NAME = "producer-operation";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getOrder() {
        return 2000;
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        if (!this.transportAccessAllowed(invocation)) {
            return CompletableFuture.failedFuture((Throwable)new InvocationException((Response.StatusType)Response.Status.UNAUTHORIZED, (Object)new CommonExceptionData("transport access not allowed.")));
        }
        invocation.onBusinessMethodStart();
        SwaggerProducerOperation producerOperation = invocation.getOperationMeta().getSwaggerProducerOperation();
        Object instance = producerOperation.getProducerInstance();
        Method method = producerOperation.getProducerMethod();
        Object[] args = invocation.toProducerArguments();
        return ((CompletableFuture)this.invoke(invocation, instance, method, args).thenApply(result -> this.convertResultToResponse(invocation, producerOperation, result))).whenComplete((response, throwable) -> this.processMetrics(invocation));
    }

    private boolean transportAccessAllowed(Invocation invocation) {
        if (invocation.getProviderTransportName() == null) {
            return true;
        }
        return invocation.getProviderTransportName().equals(invocation.getTransportName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Object> invoke(Invocation invocation, Object instance, Method method, Object[] args) {
        ContextUtils.setInvocationContext((InvocationContext)invocation);
        try {
            Object result = method.invoke(instance, args);
            if (result instanceof CompletableFuture) {
                CompletableFuture completableFuture = (CompletableFuture)result;
                return completableFuture;
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(result);
            return completableFuture;
        }
        catch (Throwable e) {
            CompletableFuture completableFuture = AsyncUtils.completeExceptionally(Exceptions.unwrap(e));
            return completableFuture;
        }
        finally {
            ContextUtils.removeInvocationContext();
        }
    }

    protected Response convertResultToResponse(Invocation invocation, SwaggerProducerOperation producerOperation, Object result) {
        return producerOperation.getResponseMapper().mapResponse(invocation.getStatus(), result);
    }

    protected void processMetrics(Invocation invocation) {
        invocation.onBusinessFinish();
    }
}

