/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.springboot.starter.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.ServerSocket;
import org.apache.servicecomb.transport.rest.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.server.AbstractConfigurableWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.core.env.Environment;

public class RestServletInitializer
implements WebServerFactoryCustomizer<AbstractConfigurableWebServerFactory>,
ServletContextInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServletInitializer.class);
    private AbstractConfigurableWebServerFactory factory = null;
    private Environment environment;

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void customize(AbstractConfigurableWebServerFactory factory) {
        this.factory = factory;
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        if (this.factory == null) {
            ServletUtils.init((ServletContext)servletContext, (Environment)this.environment);
            return;
        }
        if (this.factory.getPort() == 0) {
            LOGGER.warn("spring boot embedded web container listen port is 0, ServiceComb will not use container's port to handler REST request.");
            return;
        }
        try (ServerSocket ignored = new ServerSocket(this.factory.getPort(), 0, this.factory.getAddress());){
            ServletUtils.init((ServletContext)servletContext, (Environment)this.environment);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

