/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.context;

import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.swagger.invocation.context.HttpStatus;
import org.apache.servicecomb.swagger.invocation.context.HttpStatusManager;
import org.apache.servicecomb.swagger.invocation.context.TransportContext;

public class InvocationContext {
    private static final HttpStatusManager statusMgr = new HttpStatusManager();
    protected Response.StatusType httpStatus;
    protected final Map<String, String> context = new HashMap<String, String>();
    protected final Map<String, Object> localContext = new HashMap<String, Object>();
    protected TransportContext transportContext;

    public InvocationContext() {
        this.httpStatus = Response.Status.OK;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context.clear();
        this.addContext(context);
    }

    public void addContext(String key, String value) {
        this.context.put(key, value);
    }

    public String getContext(String key) {
        return this.context.get(key);
    }

    public void addContext(InvocationContext otherContext) {
        this.addContext(otherContext.getContext());
    }

    public void addContext(Map<String, String> otherContext) {
        if (otherContext == null) {
            return;
        }
        this.context.putAll(otherContext);
    }

    public void mergeContext(InvocationContext otherContext) {
        this.mergeContext(otherContext.getContext());
    }

    public void mergeContext(Map<String, String> otherContext) {
        if (otherContext == null) {
            return;
        }
        this.context.putAll(otherContext);
    }

    public Map<String, Object> getLocalContext() {
        return this.localContext;
    }

    public void setLocalContext(Map<String, Object> localContext) {
        this.localContext.clear();
        this.addLocalContext(localContext);
    }

    public void addLocalContext(String key, Object value) {
        this.localContext.put(key, value);
    }

    public <T> T getLocalContext(String key) {
        return (T)this.localContext.get(key);
    }

    public void addLocalContext(Map<String, Object> otherContext) {
        if (otherContext == null) {
            return;
        }
        this.localContext.putAll(otherContext);
    }

    public Response.StatusType getStatus() {
        return this.httpStatus;
    }

    public void setStatus(Response.StatusType status) {
        this.httpStatus = status;
    }

    public void setStatus(int statusCode, String reason) {
        this.httpStatus = new HttpStatus(statusCode, reason);
    }

    public void setStatus(int statusCode) {
        this.httpStatus = statusMgr.getOrCreateByStatusCode(statusCode);
    }

    public <T extends TransportContext> T getTransportContext() {
        return (T)this.transportContext;
    }

    public void setTransportContext(TransportContext transportContext) {
        this.transportContext = transportContext;
    }
}

