/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog;

import com.netflix.config.DynamicPropertyFactory;

public class AccessLogConfig {
    private static final String SERVER_BASE = "servicecomb.accesslog.";
    private static final String CLIENT_BASE = "servicecomb.accesslog.request.";
    private static final String SERVER_LOG_ENABLED = "servicecomb.accesslog.enabled";
    private static final String SERVER_LOG_PATTERN = "servicecomb.accesslog.pattern";
    private static final String CLIENT_LOG_ENABLED = "servicecomb.accesslog.request.enabled";
    private static final String CLIENT_LOG_PATTERN = "servicecomb.accesslog.request.pattern";
    private static final String DEFAULT_SERVER_PATTERN = "%h - - %t %r %s %B %D";
    private static final String DEFAULT_CLIENT_PATTERN = "%h %SCB-transport - - %t %r %s %D";
    public static final AccessLogConfig INSTANCE = new AccessLogConfig();
    private boolean serverLogEnabled;
    private boolean clientLogEnabled;
    private String serverLogPattern;
    private String clientLogPattern;

    private AccessLogConfig() {
        this.init();
    }

    private void init() {
        this.clientLogEnabled = DynamicPropertyFactory.getInstance().getBooleanProperty(CLIENT_LOG_ENABLED, false).get();
        this.serverLogEnabled = DynamicPropertyFactory.getInstance().getBooleanProperty(SERVER_LOG_ENABLED, false).get();
        this.clientLogPattern = DynamicPropertyFactory.getInstance().getStringProperty(CLIENT_LOG_PATTERN, DEFAULT_CLIENT_PATTERN).get();
        this.serverLogPattern = DynamicPropertyFactory.getInstance().getStringProperty(SERVER_LOG_PATTERN, DEFAULT_SERVER_PATTERN).get();
    }

    public boolean isServerLogEnabled() {
        return this.serverLogEnabled;
    }

    public boolean isClientLogEnabled() {
        return this.clientLogEnabled;
    }

    public String getServerLogPattern() {
        return this.serverLogPattern;
    }

    public String getClientLogPattern() {
        return this.clientLogPattern;
    }
}

