/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.foundation.common.http.HttpStatus;
import org.apache.servicecomb.foundation.vertx.http.AbstractHttpServletResponse;

public class VertxClientResponseToHttpServletResponse
extends AbstractHttpServletResponse {
    private final HttpClientResponse clientResponse;
    private Response.StatusType statusType;

    public VertxClientResponseToHttpServletResponse(HttpClientResponse clientResponse, Buffer bodyBuffer) {
        this.clientResponse = clientResponse;
        this.setBodyBuffer(bodyBuffer);
    }

    @Override
    public int getStatus() {
        return this.clientResponse.statusCode();
    }

    @Override
    public Response.StatusType getStatusType() {
        if (this.statusType == null) {
            this.statusType = new HttpStatus(this.clientResponse.statusCode(), this.clientResponse.statusMessage());
        }
        return this.statusType;
    }

    @Override
    public String getContentType() {
        return this.clientResponse.getHeader("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        return this.clientResponse.getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return this.clientResponse.headers().getAll(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.clientResponse.headers().names();
    }
}

