/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import io.opentelemetry.api.common.Attributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.client.java.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.java.metrics.GaugeEnum;
import org.apache.rocketmq.client.java.metrics.GaugeObserver;
import org.apache.rocketmq.client.java.metrics.MetricLabels;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;

public class ProcessQueueGaugeObserver
implements GaugeObserver {
    private final ConcurrentMap<MessageQueueImpl, ProcessQueue> processQueueTable;
    private final ClientId clientId;
    private final String consumerGroup;
    private final List<GaugeEnum> gauges;

    public ProcessQueueGaugeObserver(ConcurrentMap<MessageQueueImpl, ProcessQueue> processQueueTable, ClientId clientId, String consumerGroup) {
        this.processQueueTable = processQueueTable;
        this.clientId = clientId;
        this.consumerGroup = consumerGroup;
        this.gauges = new ArrayList<GaugeEnum>();
        this.gauges.add(GaugeEnum.CONSUMER_CACHED_MESSAGES);
        this.gauges.add(GaugeEnum.CONSUMER_CACHED_BYTES);
    }

    @Override
    public List<GaugeEnum> getGauges() {
        return this.gauges;
    }

    @Override
    public Map<Attributes, Double> getValues(GaugeEnum gauge) {
        switch (gauge) {
            case CONSUMER_CACHED_MESSAGES: {
                HashMap<Attributes, Double> cachedMessageCountMap = new HashMap<Attributes, Double>();
                for (ProcessQueue pq : this.processQueueTable.values()) {
                    String topic = pq.getMessageQueue().getTopic();
                    Attributes attributes = Attributes.builder().put(MetricLabels.TOPIC, (Object)topic).put(MetricLabels.CONSUMER_GROUP, (Object)this.consumerGroup).put(MetricLabels.CLIENT_ID, (Object)this.clientId.toString()).build();
                    double count = cachedMessageCountMap.containsKey(attributes) ? (Double)cachedMessageCountMap.get(attributes) : 0.0;
                    cachedMessageCountMap.put(attributes, count += (double)pq.getCachedMessageCount());
                }
                return cachedMessageCountMap;
            }
            case CONSUMER_CACHED_BYTES: {
                HashMap<Attributes, Double> cachedMessageBytesMap = new HashMap<Attributes, Double>();
                for (ProcessQueue pq : this.processQueueTable.values()) {
                    String topic = pq.getMessageQueue().getTopic();
                    Attributes attributes = Attributes.builder().put(MetricLabels.TOPIC, (Object)topic).put(MetricLabels.CONSUMER_GROUP, (Object)this.consumerGroup).put(MetricLabels.CLIENT_ID, (Object)this.clientId.toString()).build();
                    double bytes = cachedMessageBytesMap.containsKey(attributes) ? (Double)cachedMessageBytesMap.get(attributes) : 0.0;
                    cachedMessageBytesMap.put(attributes, bytes += (double)pq.getCachedMessageBytes());
                }
                return cachedMessageBytesMap;
            }
        }
        return new HashMap<Attributes, Double>();
    }
}

