/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;

final class MetricStorageUtils {
    static final int MAX_ACCUMULATIONS = 2000;

    private MetricStorageUtils() {
    }

    static <T, U extends ExemplarData> void mergeInPlace(Map<Attributes, T> result, Map<Attributes, T> toMerge, Aggregator<T, U> aggregator) {
        MetricStorageUtils.blend(result, toMerge, false, aggregator::merge);
    }

    static <T, U extends ExemplarData> void mergeAndPreserveInPlace(Map<Attributes, T> result, Map<Attributes, T> toMerge, Aggregator<T, U> aggregator) {
        MetricStorageUtils.blend(result, toMerge, true, aggregator::merge);
    }

    static <T, U extends ExemplarData> void diffInPlace(Map<Attributes, T> result, Map<Attributes, T> toDiff, Aggregator<T, U> aggregator) {
        MetricStorageUtils.blend(result, toDiff, false, aggregator::diff);
    }

    private static <T> void blend(Map<Attributes, T> result, Map<Attributes, T> toMerge, boolean preserve, BiFunction<T, T, T> blendFunction) {
        if (!preserve) {
            MetricStorageUtils.removeUnseen(result, toMerge);
        }
        toMerge.forEach((k, v) -> result.compute((Attributes)k, (k2, v2) -> v2 != null ? blendFunction.apply(v2, v) : v));
    }

    public static <T> void removeUnseen(Map<Attributes, T> result, Map<Attributes, T> latest) {
        result.entrySet().removeIf(entry -> !latest.containsKey(entry.getKey()));
    }
}

