/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlEnumMember;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;

@JsonDeserialize(using=EnumTypeDeserializer.class)
class ClientCsdlEnumType
extends CsdlEnumType
implements Serializable {
    private static final long serialVersionUID = 9191189755592743333L;

    ClientCsdlEnumType() {
    }

    static class EnumTypeDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlEnumType> {
        EnumTypeDeserializer() {
        }

        @Override
        protected ClientCsdlEnumType doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlEnumType enumType = new ClientCsdlEnumType();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        enumType.setName(jp.nextTextValue());
                    } else if ("UnderlyingType".equals(jp.getCurrentName())) {
                        enumType.setUnderlyingType(jp.nextTextValue());
                    } else if ("IsFlags".equals(jp.getCurrentName())) {
                        enumType.setFlags(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("Member".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        enumType.getMembers().add(jp.readValueAs(ClientCsdlEnumMember.class));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        enumType.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return enumType;
        }
    }
}

