/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl.listing;

import org.apache.ftpserver.command.impl.listing.FileFormater;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.util.DateUtils;
import org.apache.ftpserver.util.StringUtils;

public class MLSTFileFormater
implements FileFormater {
    private static final String[] DEFAULT_TYPES = new String[]{"Size", "Modify", "Type"};
    private String[] selectedTypes = DEFAULT_TYPES;

    public MLSTFileFormater(String[] selectedTypes) {
        if (selectedTypes != null) {
            this.selectedTypes = (String[])selectedTypes.clone();
        }
    }

    @Override
    public String format(FtpFile file) {
        StringBuilder sb = new StringBuilder();
        block10: for (String selectedType : this.selectedTypes) {
            switch (selectedType.toUpperCase()) {
                case "SIZE": {
                    sb.append("Size=");
                    sb.append(String.valueOf(file.getSize()));
                    sb.append(';');
                    continue block10;
                }
                case "MODIFY": {
                    String timeStr = DateUtils.getFtpDate(file.getLastModified());
                    sb.append("Modify=");
                    sb.append(timeStr);
                    sb.append(';');
                    continue block10;
                }
                case "TYPE": {
                    if (file.isFile()) {
                        sb.append("Type=file;");
                        continue block10;
                    }
                    if (!file.isDirectory()) continue block10;
                    sb.append("Type=dir;");
                    continue block10;
                }
                default: {
                    sb.append("Perm=");
                    if (file.isReadable()) {
                        if (file.isFile()) {
                            sb.append('r');
                        } else if (file.isDirectory()) {
                            sb.append("el");
                        }
                    }
                    if (file.isWritable()) {
                        if (file.isFile()) {
                            sb.append("adfw");
                        } else if (file.isDirectory()) {
                            sb.append("fpcm");
                        }
                    }
                    sb.append(';');
                }
            }
        }
        sb.append(' ');
        sb.append(file.getName());
        sb.append(StringUtils.NEWLINE);
        return sb.toString();
    }
}

