/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractFieldMapEntry;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldJoin;
import com.opencsv.bean.FieldMapByPositionEntry;
import com.opencsv.exceptions.CsvBadConverterException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;

public class PositionToBeanField<T>
extends AbstractFieldMapEntry<String, Integer, T>
implements Iterable<FieldMapByPositionEntry<T>> {
    private final String initializer;
    private final List<Range<Integer>> ranges;

    public PositionToBeanField(String rangeDefinition, int maxIndex, BeanField<T, Integer> field, Locale errorLocale) {
        super(field, errorLocale);
        this.initializer = rangeDefinition;
        this.ranges = new LinkedList<Range<Integer>>();
        if (StringUtils.isBlank((CharSequence)rangeDefinition)) {
            throw new CsvBadConverterException(BeanFieldJoin.class, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("invalid.range.definition"), rangeDefinition));
        }
        String[] partialRangeDefinitions = rangeDefinition.split(",");
        try {
            for (String r : partialRangeDefinitions) {
                Range range;
                if (!StringUtils.isNotEmpty((CharSequence)r)) continue;
                if (r.contains("-")) {
                    String[] endpoints = r.split("-", 2);
                    Integer min2 = StringUtils.isEmpty((CharSequence)endpoints[0]) ? Integer.valueOf(0) : Integer.valueOf(endpoints[0].trim());
                    Integer max = maxIndex;
                    if (endpoints.length == 2 && StringUtils.isNotEmpty((CharSequence)endpoints[1])) {
                        max = Integer.valueOf(endpoints[1].trim());
                    }
                    if (max >= maxIndex) {
                        max = min2 >= maxIndex ? min2 : Integer.valueOf(maxIndex);
                    }
                    range = Range.between((Comparable)min2, (Comparable)max);
                } else {
                    range = Range.is((Comparable)Integer.valueOf(r));
                }
                ListIterator<Range<Integer>> it = this.ranges.listIterator();
                boolean completelyContained = false;
                while (it.hasNext() && !completelyContained) {
                    Range<Integer> next = it.next();
                    if (next.containsRange(range)) {
                        completelyContained = true;
                        continue;
                    }
                    if (next.isOverlappedBy(range)) {
                        range = Range.between((Comparable)Integer.valueOf(Math.min((Integer)next.getMinimum(), (Integer)range.getMinimum())), (Comparable)Integer.valueOf(Math.max((Integer)next.getMaximum(), (Integer)range.getMaximum())));
                        it.remove();
                        continue;
                    }
                    if ((Integer)next.getMaximum() + 1 == (Integer)range.getMinimum()) {
                        range = Range.between((Comparable)((Comparable)next.getMinimum()), (Comparable)((Comparable)range.getMaximum()));
                        continue;
                    }
                    if ((Integer)range.getMaximum() + 1 != (Integer)next.getMinimum()) continue;
                    range = Range.between((Comparable)((Comparable)range.getMinimum()), (Comparable)((Comparable)next.getMaximum()));
                }
                if (completelyContained) continue;
                this.ranges.add((Range<Integer>)range);
            }
        }
        catch (NumberFormatException e) {
            CsvBadConverterException csve = new CsvBadConverterException(BeanFieldJoin.class, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("invalid.range.definition"), rangeDefinition));
            csve.initCause(e);
            throw csve;
        }
    }

    public void attenuateRanges(int maxIndex) {
        ListIterator<Range<Integer>> rangeIterator = this.ranges.listIterator();
        while (rangeIterator.hasNext()) {
            Range<Integer> r = rangeIterator.next();
            if ((Integer)r.getMaximum() <= maxIndex) continue;
            if ((Integer)r.getMinimum() > maxIndex) {
                rangeIterator.set((Range<Integer>)Range.is((Comparable)((Comparable)r.getMinimum())));
                continue;
            }
            rangeIterator.set((Range<Integer>)Range.between((Comparable)((Comparable)r.getMinimum()), (Comparable)Integer.valueOf(maxIndex)));
        }
    }

    @Override
    public boolean contains(Integer key) {
        return this.ranges.stream().anyMatch(range -> range.contains((Object)key));
    }

    @Override
    public String getInitializer() {
        return this.initializer;
    }

    @Override
    public Iterator<FieldMapByPositionEntry<T>> iterator() {
        return new PositionIterator();
    }

    private class PositionIterator
    implements Iterator<FieldMapByPositionEntry<T>> {
        private ListIterator<Range<Integer>> rangeIterator;
        private Range<Integer> currentRange;
        private int position;

        PositionIterator() {
            if (PositionToBeanField.this.ranges.isEmpty()) {
                this.position = -1;
            } else {
                this.rangeIterator = PositionToBeanField.this.ranges.listIterator();
                this.currentRange = this.rangeIterator.next();
                this.position = (Integer)this.currentRange.getMinimum();
            }
        }

        @Override
        public boolean hasNext() {
            return this.position != -1;
        }

        @Override
        public FieldMapByPositionEntry<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            FieldMapByPositionEntry entry = new FieldMapByPositionEntry(this.position, PositionToBeanField.this.field);
            if (this.position == (Integer)this.currentRange.getMaximum() || Integer.MAX_VALUE == (Integer)this.currentRange.getMaximum()) {
                if (!this.rangeIterator.hasNext()) {
                    this.position = -1;
                } else {
                    this.currentRange = this.rangeIterator.next();
                    this.position = (Integer)this.currentRange.getMinimum();
                }
            } else {
                ++this.position;
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

