/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.knox.gateway.shell.KnoxSession
import org.apache.knox.gateway.shell.manager.Manager
import org.apache.knox.gateway.shell.Credentials

gateway = "https://localhost:8443/gateway"

credentials = new Credentials()
credentials.add("ClearInput", "Enter username: ", "user")
           .add("HiddenInput", "Enter pas" + "sword: ", "pass")
credentials.collect()

username = credentials.get("user").string()
pass = credentials.get("pass").string()

session = KnoxSession.login( gateway, username, pass )

List<String> pcs = Manager.listProviderConfigurations(session);
System.out.println("Provider Configurations")
for (String pc : pcs) {
  System.out.println("  \u2022 " + pc)
}

List<String> descs = Manager.listDescriptors(session);
System.out.println("Descriptors")
for (String desc : descs) {
  System.out.println("  \u2022 " + desc)
}

List<String> topos = Manager.listTopologies(session);
System.out.println("Topologies")
for (String topo : topos) {
  System.out.println("  \u2022 " + topo)
}

session.shutdown()
