/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.ldap;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import org.apache.karaf.jaas.modules.ldap.LDAPLoginModule;
import org.apache.karaf.jaas.modules.ldap.LDAPOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPCache
implements Closeable,
NamespaceChangeListener,
ObjectChangeListener {
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private static final ConcurrentMap<LDAPOptions, LDAPCache> CACHES = new ConcurrentHashMap<LDAPOptions, LDAPCache>();
    private static Logger LOGGER = LoggerFactory.getLogger(LDAPLoginModule.class);
    private final long id;
    private final Map<String, String[]> userDnAndNamespace;
    private final Map<String, String[]> userRoles;
    private final Map<String, String[]> userPubkeys;
    private final LDAPOptions options;
    private DirContext context;
    private final AtomicLong userDNCacheHitCount = new AtomicLong(0L);
    private final AtomicLong userDNCacheMissCount = new AtomicLong(0L);
    private final AtomicLong userRolesCacheHitCount = new AtomicLong(0L);
    private final AtomicLong userRolesCacheMissCount = new AtomicLong(0L);
    private final AtomicLong userPubkeysCacheHitCount = new AtomicLong(0L);
    private final AtomicLong userPubkeysCacheMissCount = new AtomicLong(0L);
    private final AtomicLong clearCacheCount = new AtomicLong(0L);

    public static void clear() {
        while (!CACHES.isEmpty()) {
            LDAPOptions options = (LDAPOptions)CACHES.keySet().iterator().next();
            LDAPCache cache = (LDAPCache)CACHES.remove(options);
            if (cache == null) continue;
            cache.clearCache();
        }
    }

    public static LDAPCache getCache(LDAPOptions options) {
        LDAPCache cache = (LDAPCache)CACHES.get(options);
        if (cache == null) {
            CACHES.putIfAbsent(options, new LDAPCache(options));
            cache = (LDAPCache)CACHES.get(options);
        }
        return cache;
    }

    public static LDAPCache removeCache(long id) {
        LDAPOptions match = null;
        for (Map.Entry entry : CACHES.entrySet()) {
            if (((LDAPCache)entry.getValue()).getId() != id) continue;
            match = (LDAPOptions)entry.getKey();
        }
        if (match != null) {
            return (LDAPCache)CACHES.remove(match);
        }
        return null;
    }

    public static Map<LDAPOptions, LDAPCache> getCacheCopy() {
        return Collections.unmodifiableMap(CACHES);
    }

    public LDAPCache(LDAPOptions options) {
        this.options = options;
        this.id = idGenerator.getAndIncrement();
        this.userDnAndNamespace = new HashMap<String, String[]>();
        this.userRoles = new HashMap<String, String[]>();
        this.userPubkeys = new HashMap<String, String[]>();
    }

    @Override
    public synchronized void close() {
        this.clearCache();
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException namingException) {
            }
            finally {
                this.context = null;
            }
        }
    }

    private boolean isContextAlive() {
        boolean alive = false;
        if (this.context != null) {
            try {
                this.context.getAttributes("");
                alive = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return alive;
    }

    public synchronized DirContext open() throws NamingException {
        if (this.isContextAlive()) {
            return this.context;
        }
        this.clearCache();
        this.context = new InitialDirContext(this.options.getEnv());
        EventDirContext eventContext = (EventDirContext)this.context.lookup("");
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        if (!this.options.getDisableCache()) {
            String filter = this.options.getUserFilter();
            filter = filter.replaceAll(Pattern.quote("%u"), Matcher.quoteReplacement("*"));
            filter = filter.replace("\\", "\\\\");
            eventContext.addNamingListener(this.options.getUserBaseDn(), filter, constraints, (NamingListener)this);
            filter = this.options.getRoleFilter();
            if (filter != null) {
                filter = filter.replaceAll(Pattern.quote("%u"), Matcher.quoteReplacement("*"));
                filter = filter.replaceAll(Pattern.quote("%dn"), Matcher.quoteReplacement("*"));
                filter = filter.replaceAll(Pattern.quote("%fqdn"), Matcher.quoteReplacement("*"));
                filter = filter.replace("\\", "\\\\");
                eventContext.addNamingListener(this.options.getRoleBaseDn(), filter, constraints, (NamingListener)this);
            }
        }
        return this.context;
    }

    public synchronized String[] getUserDnAndNamespace(String user) throws Exception {
        String[] result = this.userDnAndNamespace.get(user);
        if (result == null) {
            this.userDNCacheMissCount.incrementAndGet();
            result = this.doGetUserDnAndNamespace(user);
            if (result != null && !this.options.getDisableCache()) {
                this.userDnAndNamespace.put(user, result);
            }
        } else {
            this.userDNCacheHitCount.incrementAndGet();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] doGetUserDnAndNamespace(String user) throws NamingException {
        DirContext context = this.open();
        SearchControls controls = new SearchControls();
        if (this.options.getUserSearchSubtree()) {
            controls.setSearchScope(2);
        } else {
            controls.setSearchScope(1);
        }
        String filter = this.options.getUserFilter();
        filter = filter.replaceAll(Pattern.quote("%u"), Matcher.quoteReplacement(user));
        filter = filter.replace("\\", "\\\\");
        LOGGER.debug("Looking for the user in LDAP with ");
        LOGGER.debug("  base DN: " + this.options.getUserBaseDn());
        LOGGER.debug("  filter: " + filter);
        NamingEnumeration<SearchResult> namingEnumeration = context.search(this.options.getUserBaseDn(), filter, controls);
        if (!namingEnumeration.hasMore()) {
            LOGGER.warn("User " + user + " not found in LDAP.");
            String[] stringArray = null;
            return stringArray;
        }
        LOGGER.debug("Found the user DN.");
        SearchResult result = namingEnumeration.next();
        String userDNNamespace = result.getNameInNamespace();
        int indexOfUserBaseDN = userDNNamespace.toLowerCase().indexOf("," + this.options.getUserBaseDn().toLowerCase());
        String userDN = indexOfUserBaseDN > 0 ? userDNNamespace.substring(0, indexOfUserBaseDN) : result.getName();
        String[] stringArray = new String[]{userDN, userDNNamespace};
        return stringArray;
        finally {
            if (namingEnumeration != null) {
                try {
                    namingEnumeration.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    public synchronized String[] getUserRoles(String user, String userDn, String userDnNamespace) throws Exception {
        String[] result = this.userRoles.get(userDn);
        if (result == null) {
            this.userRolesCacheMissCount.incrementAndGet();
            result = this.doGetUserRoles(user, userDn, userDnNamespace);
            if (!this.options.getDisableCache()) {
                this.userRoles.put(userDn, result);
            }
        } else {
            this.userRolesCacheHitCount.incrementAndGet();
        }
        return result;
    }

    public synchronized String[] getUserPubkeys(String userDn) throws NamingException {
        String[] result = this.userPubkeys.get(userDn);
        if (result == null) {
            this.userPubkeysCacheMissCount.incrementAndGet();
            result = this.doGetUserPubkeys(userDn);
            if (!this.options.getDisableCache()) {
                this.userPubkeys.put(userDn, result);
            }
        } else {
            this.userPubkeysCacheHitCount.incrementAndGet();
        }
        return result;
    }

    protected Set<String> tryMappingRole(String role) {
        HashSet<String> roles = new HashSet<String>();
        if (this.options.getRoleMapping().isEmpty()) {
            return roles;
        }
        Set<String> karafRoles = this.options.getRoleMapping().get(role);
        if (karafRoles != null) {
            for (String karafRole : karafRoles) {
                LOGGER.debug("LDAP role {} is mapped to Karaf role {}", (Object)role, (Object)karafRole);
                roles.add(karafRole);
            }
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] doGetUserRoles(String user, String userDn, String userDnNamespace) throws NamingException {
        DirContext context = this.open();
        SearchControls controls = new SearchControls();
        if (this.options.getRoleSearchSubtree()) {
            controls.setSearchScope(2);
        } else {
            controls.setSearchScope(1);
        }
        String filter = this.options.getRoleFilter();
        if (filter != null) {
            ArrayList<String> rolesList;
            block19: {
                filter = filter.replaceAll(Pattern.quote("%u"), Matcher.quoteReplacement(user));
                filter = filter.replaceAll(Pattern.quote("%dn"), Matcher.quoteReplacement(userDn));
                filter = filter.replaceAll(Pattern.quote("%fqdn"), Matcher.quoteReplacement(userDnNamespace));
                filter = filter.replace("\\", "\\\\");
                LOGGER.debug("Looking for the user roles in LDAP with ");
                LOGGER.debug("  base DN: {}", (Object)this.options.getRoleBaseDn());
                LOGGER.debug("  filter: {}", (Object)filter);
                NamingEnumeration<SearchResult> namingEnumeration = context.search(this.options.getRoleBaseDn(), filter, controls);
                rolesList = new ArrayList<String>();
                try {
                    while (namingEnumeration.hasMore()) {
                        SearchResult result = namingEnumeration.next();
                        Attributes attributes = result.getAttributes();
                        Attribute roles1 = attributes.get(this.options.getRoleNameAttribute());
                        if (roles1 == null) continue;
                        for (int i = 0; i < roles1.size(); ++i) {
                            String role = (String)roles1.get(i);
                            if (role == null) continue;
                            LOGGER.debug("User {} is a member of role {}", (Object)user, (Object)role);
                            Set<String> roleMappings = this.tryMappingRole(role);
                            if (roleMappings.isEmpty()) {
                                rolesList.add(role);
                                continue;
                            }
                            rolesList.addAll(roleMappings);
                        }
                    }
                }
                catch (PartialResultException e) {
                    if (this.options.getIgnorePartialResultException()) {
                        LOGGER.debug("PartialResultException encountered and ignored", (Throwable)e);
                        break block19;
                    }
                    throw e;
                }
                finally {
                    if (namingEnumeration != null) {
                        try {
                            namingEnumeration.close();
                        }
                        catch (NamingException namingException) {}
                    }
                }
            }
            return rolesList.toArray(new String[rolesList.size()]);
        }
        LOGGER.debug("The user role filter is null so no roles are retrieved");
        return new String[0];
    }

    private String[] doGetUserPubkeys(String userDn) throws NamingException {
        DirContext context = this.open();
        String userPubkeyAttribute = this.options.getUserPubkeyAttribute();
        if (userPubkeyAttribute != null) {
            LOGGER.debug("Looking for public keys of user {} in attribute {}", (Object)userDn, (Object)userPubkeyAttribute);
            Attributes attributes = context.getAttributes(userDn, new String[]{userPubkeyAttribute});
            Attribute pubkeyAttribute = attributes.get(userPubkeyAttribute);
            ArrayList<String> pubkeyList = new ArrayList<String>();
            if (pubkeyAttribute != null) {
                for (int i = 0; i < pubkeyAttribute.size(); ++i) {
                    String pk = (String)pubkeyAttribute.get(i);
                    if (pk == null) continue;
                    pubkeyList.add(pk);
                }
            }
            return pubkeyList.toArray(new String[pubkeyList.size()]);
        }
        LOGGER.debug("The user public key attribute is null so no keys were retrieved");
        return new String[0];
    }

    @Override
    public void objectAdded(NamingEvent evt) {
        this.clearCache();
    }

    @Override
    public void objectRemoved(NamingEvent evt) {
        this.clearCache();
    }

    @Override
    public void objectRenamed(NamingEvent evt) {
        this.clearCache();
    }

    @Override
    public void objectChanged(NamingEvent evt) {
        this.clearCache();
    }

    @Override
    public void namingExceptionThrown(NamingExceptionEvent evt) {
        this.clearCache();
    }

    protected synchronized void clearCache() {
        this.clearCacheCount.incrementAndGet();
        this.userDnAndNamespace.clear();
        this.userRoles.clear();
        this.userPubkeys.clear();
    }

    public Map<String, String[]> listCachedUserDNAndNamespace() {
        return Collections.unmodifiableMap(this.userDnAndNamespace);
    }

    public Map<String, String[]> listCachedUserPubkeys() {
        return Collections.unmodifiableMap(this.userPubkeys);
    }

    public Map<String, String[]> listCachedUserRoles() {
        return Collections.unmodifiableMap(this.userRoles);
    }

    public long getUserDNCacheHitCount() {
        return this.userDNCacheHitCount.get();
    }

    public long getUserDNCacheMissCount() {
        return this.userDNCacheMissCount.get();
    }

    public long getUserRolesCacheHitCount() {
        return this.userRolesCacheHitCount.get();
    }

    public long getUserRolesCacheMissCount() {
        return this.userRolesCacheMissCount.get();
    }

    public long getUserPubkeysCacheHitCount() {
        return this.userPubkeysCacheHitCount.get();
    }

    public long getUserPubkeysCacheMissCount() {
        return this.userPubkeysCacheMissCount.get();
    }

    public long getClearCacheCount() {
        return this.clearCacheCount.get();
    }

    public long getId() {
        return this.id;
    }
}

