/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import com.google.common.io.CountingOutputStream;
import com.google.common.io.FileBackedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Disposable;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.util.ByteArrayOutputStreamRecycler;
import org.apache.james.mime4j.util.ContentUtil;
import org.apache.james.util.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBufferedBodyFactory
implements BodyFactory,
Disposable {
    public static final BasicBodyFactory INSTANCE = new BasicBodyFactory();
    public static final Logger LOGGER = LoggerFactory.getLogger(FileBufferedBodyFactory.class);
    public static final int FILE_THRESHOLD = Optional.ofNullable(System.getProperty("james.mime4j.buffered.body.factory.file.threshold")).map(s -> Size.parse((String)s, (Size.Unit)Size.Unit.NoUnit)).map(s -> (int)s.asBytes()).orElse(102400);
    private final Charset defaultCharset;
    private final ArrayList<Disposable> disposables = new ArrayList();

    public FileBufferedBodyFactory() {
        this(true);
    }

    public FileBufferedBodyFactory(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public FileBufferedBodyFactory(boolean lenient) {
        this(lenient ? Charset.defaultCharset() : null);
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    protected Charset resolveCharset(String mimeCharset) throws UnsupportedEncodingException {
        block5: {
            if (mimeCharset != null) {
                try {
                    return Charset.forName(mimeCharset);
                }
                catch (UnsupportedCharsetException ex) {
                    if (this.defaultCharset == null) {
                        throw new UnsupportedEncodingException(mimeCharset);
                    }
                }
                catch (IllegalCharsetNameException ex) {
                    if (this.defaultCharset != null) break block5;
                    throw new UnsupportedEncodingException(mimeCharset);
                }
            }
        }
        return this.defaultCharset;
    }

    public TextBody textBody(String text, String mimeCharset) throws UnsupportedEncodingException {
        if (text == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        return new StringBody1(text, this.resolveCharset(mimeCharset));
    }

    public TextBody textBody(byte[] content, Charset charset) {
        if (content == null) {
            throw new IllegalArgumentException("Content may not be null");
        }
        return new StringBody2(content, charset);
    }

    public TextBody textBody(InputStream content, String mimeCharset) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        return new StringBody3(ContentUtil.bufferEfficient((InputStream)content), this.resolveCharset(mimeCharset));
    }

    public TextBody textBody(String text, Charset charset) {
        if (text == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        return new StringBody1(text, charset);
    }

    public TextBody textBody(String text) {
        return this.textBody(text, Charsets.DEFAULT_CHARSET);
    }

    public BinaryBody binaryBody(String content, Charset charset) {
        if (content == null) {
            throw new IllegalArgumentException("Content may not be null");
        }
        return new BinaryBody2(content, charset);
    }

    public BinaryBody binaryBody(InputStream is) throws IOException {
        try (FileBackedOutputStream out = new FileBackedOutputStream(FILE_THRESHOLD);){
            this.disposables.add(() -> {
                try {
                    out.reset();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot delete {}", (Object)out, (Object)e);
                }
            });
            CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)out);
            is.transferTo((OutputStream)countingOutputStream);
            BinaryBody3 binaryBody3 = new BinaryBody3(out, countingOutputStream.getCount());
            return binaryBody3;
        }
    }

    public BinaryBody binaryBody(byte[] buf) {
        return new BinaryBody1(buf);
    }

    public void dispose() {
        this.disposables.forEach(Disposable::dispose);
    }

    static class StringBody1
    extends TextBody {
        private final String content;
        private final Charset charset;

        StringBody1(String content, Charset charset) {
            this.content = content;
            this.charset = charset;
        }

        public String getMimeCharset() {
            return this.charset != null ? this.charset.name() : null;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Reader getReader() throws IOException {
            return new StringReader(this.content);
        }

        public InputStream getInputStream() throws IOException {
            return InputStreams.create((CharSequence)this.content, (Charset)(this.charset != null ? this.charset : Charsets.DEFAULT_CHARSET));
        }

        public void dispose() {
        }

        public SingleBody copy() {
            return new StringBody1(this.content, this.charset);
        }
    }

    static class StringBody2
    extends TextBody {
        private final byte[] content;
        private final Charset charset;

        StringBody2(byte[] content, Charset charset) {
            this.content = content;
            this.charset = charset;
        }

        public String getMimeCharset() {
            return this.charset != null ? this.charset.name() : null;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Reader getReader() throws IOException {
            return new InputStreamReader(InputStreams.create((byte[])this.content), this.charset);
        }

        public InputStream getInputStream() throws IOException {
            return InputStreams.create((byte[])this.content);
        }

        public void writeTo(OutputStream out) throws IOException {
            out.write(this.content);
        }

        public long size() {
            return this.content.length;
        }

        public void dispose() {
        }

        public SingleBody copy() {
            return new StringBody2(this.content, this.charset);
        }
    }

    static class StringBody3
    extends TextBody {
        private final ByteArrayOutputStreamRecycler.Wrapper content;
        private final Charset charset;

        StringBody3(ByteArrayOutputStreamRecycler.Wrapper content, Charset charset) {
            this.content = content;
            this.charset = charset;
        }

        public String getMimeCharset() {
            return this.charset != null ? this.charset.name() : null;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Reader getReader() throws IOException {
            return new InputStreamReader(this.content.getValue().toInputStream(), this.charset);
        }

        public InputStream getInputStream() throws IOException {
            return this.content.getValue().toInputStream();
        }

        public long size() {
            return this.content.getValue().size();
        }

        public void writeTo(OutputStream out) throws IOException {
            this.content.getValue().writeTo(out);
        }

        public void dispose() {
            this.content.release();
        }

        public SingleBody copy() {
            return new StringBody3(this.content, this.charset);
        }
    }

    static class BinaryBody2
    extends BinaryBody {
        private final String content;
        private final Charset charset;

        BinaryBody2(String content, Charset charset) {
            this.content = content;
            this.charset = charset;
        }

        public InputStream getInputStream() throws IOException {
            return InputStreams.create((CharSequence)this.content, (Charset)(this.charset != null ? this.charset : Charsets.DEFAULT_CHARSET));
        }

        public void dispose() {
        }

        public SingleBody copy() {
            return new BinaryBody2(this.content, this.charset);
        }
    }

    static class BinaryBody3
    extends BinaryBody {
        private final FileBackedOutputStream data;
        private final long size;

        BinaryBody3(FileBackedOutputStream data, long size) {
            this.data = data;
            this.size = size;
        }

        public InputStream getInputStream() throws IOException {
            return this.data.asByteSource().openStream();
        }

        public void writeTo(OutputStream out) throws IOException {
            try (InputStream inputStream = this.getInputStream();){
                inputStream.transferTo(out);
            }
        }

        public long size() {
            return this.size;
        }

        public void dispose() {
            try {
                this.data.close();
                this.data.reset();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public SingleBody copy() {
            return new BinaryBody3(this.data, this.size);
        }
    }

    static class BinaryBody1
    extends BinaryBody {
        private final byte[] content;

        BinaryBody1(byte[] content) {
            this.content = content;
        }

        public InputStream getInputStream() throws IOException {
            return InputStreams.create((byte[])this.content);
        }

        public void writeTo(OutputStream out) throws IOException {
            out.write(this.content);
        }

        public long size() {
            return this.content.length;
        }

        public void dispose() {
        }

        public SingleBody copy() {
            return new BinaryBody1(this.content);
        }
    }
}

