/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.dto;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.internet.AddressException;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.dto.DeletedMessageWithStorageInformationDTO;
import org.apache.james.vault.metadata.DeletedMessageWithStorageInformation;
import org.apache.james.vault.metadata.StorageInformation;

public class DeletedMessageWithStorageInformationConverter {
    private final BlobId.Factory blobFactory;
    private final MessageId.Factory messageIdFactory;
    private final MailboxId.Factory mailboxIdFactory;

    @Inject
    public DeletedMessageWithStorageInformationConverter(BlobId.Factory blobFactory, MessageId.Factory messageIdFactory, MailboxId.Factory mailboxIdFactory) {
        this.blobFactory = blobFactory;
        this.messageIdFactory = messageIdFactory;
        this.mailboxIdFactory = mailboxIdFactory;
    }

    public StorageInformation toDomainObject(DeletedMessageWithStorageInformationDTO.StorageInformationDTO storageInformationDTO) {
        return StorageInformation.builder().bucketName(BucketName.of((String)storageInformationDTO.getBucketName())).blobId(this.blobFactory.parse(storageInformationDTO.getBlobId()));
    }

    public DeletedMessage toDomainObject(DeletedMessageWithStorageInformationDTO.DeletedMessageDTO deletedMessageDTO) throws AddressException {
        return ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId(this.messageIdFactory.fromString(deletedMessageDTO.getMessageId()))).originMailboxes((List<MailboxId>)this.deserializeOriginMailboxes(deletedMessageDTO.getOriginMailboxes()))).user(Username.of((String)deletedMessageDTO.getOwner()))).deliveryDate(ZonedDateTime.parse(deletedMessageDTO.getDeliveryDate()))).deletionDate(ZonedDateTime.parse(deletedMessageDTO.getDeletionDate()))).sender(MaybeSender.getMailSender((String)deletedMessageDTO.getSender()))).recipients((Collection<MailAddress>)this.deserializeRecipients(deletedMessageDTO.getRecipients()))).hasAttachment(deletedMessageDTO.getHasAttachment())).size(deletedMessageDTO.getSize())).subject(deletedMessageDTO.getSubject()).build();
    }

    public DeletedMessageWithStorageInformation toDomainObject(DeletedMessageWithStorageInformationDTO deletedMessageWithStorageInfoDTO) throws AddressException {
        return new DeletedMessageWithStorageInformation(this.toDomainObject(deletedMessageWithStorageInfoDTO.getDeletedMessage()), this.toDomainObject(deletedMessageWithStorageInfoDTO.getStorageInformation()));
    }

    private ImmutableList<MailboxId> deserializeOriginMailboxes(List<String> originMailboxes) {
        return (ImmutableList)originMailboxes.stream().map(mailboxId -> this.mailboxIdFactory.fromString(mailboxId)).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<MailAddress> deserializeRecipients(List<String> recipients) throws AddressException {
        return (ImmutableList)recipients.stream().map(Throwing.function(MailAddress::new).sneakyThrow()).collect(ImmutableList.toImmutableList());
    }
}

