/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.google.common.collect.ImmutableList;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;
import org.apache.james.backends.cassandra.components.CassandraType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraTypesCreator {
    private final ImmutableList<CassandraType> types;
    private final CqlSession session;

    public CassandraTypesCreator(CassandraDataDefinition module, CqlSession session) {
        this.types = ImmutableList.copyOf(module.moduleTypes());
        this.session = session;
    }

    public CassandraType.InitializationStatus initializeTypes() {
        KeyspaceMetadata keyspaceMetadata = (KeyspaceMetadata)this.session.getMetadata().getKeyspaces().get(this.session.getKeyspace().get());
        return (CassandraType.InitializationStatus)((Object)Flux.fromIterable(this.types).flatMap(type -> type.initialize(keyspaceMetadata, this.session)).reduce(CassandraType.InitializationStatus::reduce).switchIfEmpty(Mono.just((Object)((Object)CassandraType.InitializationStatus.ALREADY_DONE))).block());
    }
}

