/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.SubscriptionWithCancelException;
import org.apache.pekko.stream.impl.CancelledSubscription$;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.util.control.NonFatal$;

@InternalApi
public final class ReactiveStreamsCompliance$ {
    public static final ReactiveStreamsCompliance$ MODULE$ = new ReactiveStreamsCompliance$();

    public final String CanNotSubscribeTheSameSubscriberMultipleTimes() {
        return "can not subscribe the same subscriber multiple times (see reactive-streams specification, rules 1.10 and 2.12)";
    }

    public final String SupportsOnlyASingleSubscriber() {
        return "only supports one subscriber (which is allowed, see reactive-streams specification, rule 1.11)";
    }

    public final String NumberOfElementsInRequestMustBePositiveMsg() {
        return "The number of requested elements must be > 0 (see reactive-streams specification, rule 3.9)";
    }

    public final String SubscriberMustNotBeNullMsg() {
        return "Subscriber must not be null, rule 1.9";
    }

    public final String ExceptionMustNotBeNullMsg() {
        return "Exception must not be null, rule 2.13";
    }

    public final String ElementMustNotBeNullMsg() {
        return "Element must not be null, rule 2.13";
    }

    public final String SubscriptionMustNotBeNullMsg() {
        return "Subscription must not be null, rule 2.13";
    }

    public final Throwable numberOfElementsInRequestMustBePositiveException() {
        return new IllegalArgumentException("The number of requested elements must be > 0 (see reactive-streams specification, rule 3.9)");
    }

    public final Throwable canNotSubscribeTheSameSubscriberMultipleTimesException() {
        return new IllegalStateException("can not subscribe the same subscriber multiple times (see reactive-streams specification, rules 1.10 and 2.12)");
    }

    public final Throwable subscriberMustNotBeNullException() {
        return new NullPointerException("Subscriber must not be null, rule 1.9");
    }

    public final Throwable exceptionMustNotBeNullException() {
        return new NullPointerException("Exception must not be null, rule 2.13");
    }

    public final Throwable elementMustNotBeNullException() {
        return new NullPointerException("Element must not be null, rule 2.13");
    }

    public final Throwable subscriptionMustNotBeNullException() {
        return new NullPointerException("Subscription must not be null, rule 2.13");
    }

    public final <T> void rejectDuplicateSubscriber(Subscriber<T> subscriber) {
        this.tryOnError(subscriber, new IllegalStateException("can not subscribe the same subscriber multiple times (see reactive-streams specification, rules 1.10 and 2.12)"));
    }

    public final <T> void rejectAdditionalSubscriber(Subscriber<T> subscriber, String rejector) {
        this.tryOnSubscribe(subscriber, CancelledSubscription$.MODULE$);
        this.tryOnError(subscriber, new IllegalStateException(new StringBuilder(95).append(rejector).append(" ").append("only supports one subscriber (which is allowed, see reactive-streams specification, rule 1.11)").toString()));
    }

    public final <T> void rejectDueToNonPositiveDemand(Subscriber<T> subscriber) {
        this.tryOnError(subscriber, new IllegalArgumentException("The number of requested elements must be > 0 (see reactive-streams specification, rule 3.9)"));
    }

    public final <T> void requireNonNullSubscriber(Subscriber<T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("Subscriber must not be null, rule 1.9");
        }
    }

    public final void requireNonNullException(Throwable cause) {
        if (cause == null) {
            throw new NullPointerException("Exception must not be null, rule 2.13");
        }
    }

    public final <T> void requireNonNullElement(T element) {
        if (element == null) {
            throw new NullPointerException("Element must not be null, rule 2.13");
        }
    }

    public final void requireNonNullSubscription(Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("Subscription must not be null, rule 2.13");
        }
    }

    public final <T> void tryOnError(Subscriber<T> subscriber, Throwable error) {
        if (error instanceof ReactiveStreamsCompliance.SpecViolation) {
            ReactiveStreamsCompliance.SpecViolation specViolation = (ReactiveStreamsCompliance.SpecViolation)((Object)error);
            throw new IllegalStateException("It is not legal to try to signal onError with a SpecViolation", (Throwable)((Object)specViolation));
        }
        try {
            subscriber.onError(error);
            return;
        }
        catch (Throwable throwable) {
            if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                throw new ReactiveStreamsCompliance.SignalThrewException(new StringBuilder(8).append(subscriber).append(".onError").toString(), throwable);
            }
            throw throwable;
        }
    }

    public final <T> void tryOnNext(Subscriber<T> subscriber, T element) {
        this.requireNonNullElement(element);
        try {
            subscriber.onNext(element);
            return;
        }
        catch (Throwable throwable) {
            if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                throw new ReactiveStreamsCompliance.SignalThrewException(new StringBuilder(7).append(subscriber).append(".onNext").toString(), throwable);
            }
            throw throwable;
        }
    }

    public final <T> void tryOnSubscribe(Subscriber<T> subscriber, Subscription subscription) {
        try {
            subscriber.onSubscribe(subscription);
            return;
        }
        catch (Throwable throwable) {
            if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                throw new ReactiveStreamsCompliance.SignalThrewException(new StringBuilder(12).append(subscriber).append(".onSubscribe").toString(), throwable);
            }
            throw throwable;
        }
    }

    public final <T> void tryOnComplete(Subscriber<T> subscriber) {
        try {
            subscriber.onComplete();
            return;
        }
        catch (Throwable throwable) {
            if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                throw new ReactiveStreamsCompliance.SignalThrewException(new StringBuilder(11).append(subscriber).append(".onComplete").toString(), throwable);
            }
            throw throwable;
        }
    }

    public final void tryRequest(Subscription subscription, long demand) {
        if (subscription == null) {
            throw new IllegalStateException("Subscription must be not null on request() call, rule 1.3");
        }
        try {
            subscription.request(demand);
            return;
        }
        catch (Throwable throwable) {
            if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                throw new ReactiveStreamsCompliance.SignalThrewException("It is illegal to throw exceptions from request(), rule 3.16", throwable);
            }
            throw throwable;
        }
    }

    public final void tryCancel(Subscription subscription, Throwable cause) {
        if (subscription == null) {
            throw new IllegalStateException("Subscription must be not null on cancel() call, rule 1.3");
        }
        try {
            if (subscription instanceof SubscriptionWithCancelException) {
                ((SubscriptionWithCancelException)subscription).cancel(cause);
            } else {
                subscription.cancel();
            }
        }
        catch (Throwable throwable) {
            if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                throw new ReactiveStreamsCompliance.SignalThrewException("It is illegal to throw exceptions from cancel(), rule 3.15", throwable);
            }
            throw throwable;
        }
    }

    private ReactiveStreamsCompliance$() {
    }
}

