/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.Show;
import cats.Show$;
import cats.kernel.Eq;
import cats.package$;
import io.circe.Json;
import io.circe.Json$JNull$;
import io.circe.JsonBigDecimal;
import io.circe.JsonBiggerDecimal;
import io.circe.JsonDouble;
import io.circe.JsonFloat;
import io.circe.JsonNumber;
import io.circe.JsonNumber$;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import io.circe.numbers.BiggerDecimal$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Json$
implements Serializable {
    public static final Json$ MODULE$ = new Json$();
    private static final Json Null = Json$JNull$.MODULE$;
    private static final Json True = new Json.JBoolean(true);
    private static final Json False = new Json.JBoolean(false);
    private static final Json EmptyArray = new Json.JArray((Vector<Json>)scala.package$.MODULE$.Vector().empty());
    private static final Json EmptyString = new Json.JString("");
    private static final Eq<Json> eqJson = package$.MODULE$.Eq().instance((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)Json$.$anonfun$eqJson$1(x0$1, x1$1)));
    private static final Show<Json> showJson = Show$.MODULE$.fromToString();

    public final Json Null() {
        return Null;
    }

    public final Json True() {
        return True;
    }

    public final Json False() {
        return False;
    }

    public final Json obj(Seq<Tuple2<String, Json>> fields) {
        return this.fromFields((Iterable<Tuple2<String, Json>>)fields);
    }

    public final Json arr(Seq<Json> values) {
        return this.fromValues((Iterable<Json>)values);
    }

    public final Json fromFields(Iterable<Tuple2<String, Json>> fields) {
        return new Json.JObject(JsonObject$.MODULE$.fromIterable(fields));
    }

    public final Json fromValues(Iterable<Json> values) {
        if (values.isEmpty()) {
            return EmptyArray;
        }
        return new Json.JArray((Vector<Json>)values.toVector());
    }

    public final Json fromJsonObject(JsonObject value) {
        return new Json.JObject(value);
    }

    public final Json fromJsonNumber(JsonNumber value) {
        return new Json.JNumber(value);
    }

    public final Json fromString(String value) {
        if (value.isEmpty()) {
            return EmptyString;
        }
        return new Json.JString(value);
    }

    public final Json fromStringOrNull(Option<String> value2) {
        return (Json)value2.fold((Function0 & Serializable)() -> MODULE$.Null(), (Function1 & Serializable)value -> MODULE$.fromString((String)value));
    }

    public final Json fromBoolean(boolean value) {
        if (value) {
            return this.True();
        }
        return this.False();
    }

    public final Json fromBooleanOrNull(Option<Object> value2) {
        return (Json)value2.fold((Function0 & Serializable)() -> MODULE$.Null(), (Function1 & Serializable)value -> Json$.MODULE$.fromBoolean(BoxesRunTime.unboxToBoolean((Object)value)));
    }

    public final Json fromInt(int value) {
        return JsonNumber$.MODULE$.fromLong(value);
    }

    public final Json fromIntOrNull(Option<Object> value2) {
        return (Json)value2.fold((Function0 & Serializable)() -> MODULE$.Null(), (Function1 & Serializable)value -> Json$.MODULE$.fromInt(BoxesRunTime.unboxToInt((Object)value)));
    }

    public final Json fromLong(long value) {
        return JsonNumber$.MODULE$.fromLong(value);
    }

    public final Json fromLongOrNull(Option<Object> value2) {
        return (Json)value2.fold((Function0 & Serializable)() -> MODULE$.Null(), (Function1 & Serializable)value -> Json$.MODULE$.fromLong(BoxesRunTime.unboxToLong((Object)value)));
    }

    public final Option<Json> fromDouble(double value) {
        if (this.isReal(value)) {
            return new Some((Object)new Json.JNumber(new JsonDouble(value)));
        }
        return None$.MODULE$;
    }

    public final Option<Json> fromFloat(float value) {
        if (this.isReal(value)) {
            return new Some((Object)new Json.JNumber(new JsonFloat(value)));
        }
        return None$.MODULE$;
    }

    public final Json fromDoubleOrNull(Option<Object> value2) {
        return (Json)value2.fold((Function0 & Serializable)() -> MODULE$.Null(), (Function1 & Serializable)value -> Json$.MODULE$.fromDoubleOrNull(BoxesRunTime.unboxToDouble((Object)value)));
    }

    public final Json fromDoubleOrNull(double value) {
        if (this.isReal(value)) {
            return new Json.JNumber(new JsonDouble(value));
        }
        return this.Null();
    }

    public final Json fromFloatOrNull(float value) {
        if (this.isReal(value)) {
            return new Json.JNumber(new JsonFloat(value));
        }
        return this.Null();
    }

    public final Json fromFloatOrNull(Option<Object> value2) {
        return (Json)value2.fold((Function0 & Serializable)() -> MODULE$.Null(), (Function1 & Serializable)value -> Json$.MODULE$.fromFloatOrNull(BoxesRunTime.unboxToFloat((Object)value)));
    }

    public final Json fromDoubleOrString(double value) {
        if (this.isReal(value)) {
            return new Json.JNumber(new JsonDouble(value));
        }
        return this.fromString(Double.toString(value));
    }

    public final Json fromFloatOrString(float value) {
        if (this.isReal(value)) {
            return new Json.JNumber(new JsonFloat(value));
        }
        return this.fromString(Float.toString(value));
    }

    public final Json fromBigInt(BigInt value) {
        return new Json.JNumber(new JsonBiggerDecimal(BiggerDecimal$.MODULE$.fromBigInteger(value.underlying()), value.toString()));
    }

    public final Json fromBigIntOrNull(Option<BigInt> value2) {
        return (Json)value2.fold((Function0 & Serializable)() -> MODULE$.Null(), (Function1 & Serializable)value -> MODULE$.fromBigInt((BigInt)value));
    }

    public final Json fromBigDecimal(BigDecimal value) {
        return new Json.JNumber(new JsonBigDecimal(value.underlying()));
    }

    public final Json fromBigDecimalOrNull(Option<BigDecimal> value2) {
        return (Json)value2.fold((Function0 & Serializable)() -> MODULE$.Null(), (Function1 & Serializable)value -> MODULE$.fromBigDecimal((BigDecimal)value));
    }

    private boolean isReal(double value) {
        return Double.isFinite(value);
    }

    private boolean isReal(float value) {
        return Float.isFinite(value);
    }

    private final boolean arrayEq(Vector<Json> x, Vector<Json> y) {
        if (x.length() != y.length()) {
            return false;
        }
        Iterator it0 = x.iterator();
        Iterator it1 = y.iterator();
        while (it0.hasNext()) {
            if (!this.eqJson().neqv(it0.next(), it1.next())) continue;
            return false;
        }
        return true;
    }

    public final Eq<Json> eqJson() {
        return eqJson;
    }

    public final Show<Json> showJson() {
        return showJson;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Json$.class);
    }

    public static final /* synthetic */ boolean $anonfun$eqJson$1(Json x0$1, Json x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            Json json = (Json)tuple2._1();
            Json json2 = (Json)tuple2._2();
            if (json instanceof Json.JObject) {
                Json.JObject jObject = (Json.JObject)json;
                JsonObject a = jObject.value();
                if (json2 instanceof Json.JObject) {
                    Json.JObject jObject2 = (Json.JObject)json2;
                    JsonObject b = jObject2.value();
                    return JsonObject$.MODULE$.eqJsonObject().eqv((Object)a, (Object)b);
                }
            }
        }
        if (tuple2 != null) {
            Json json = (Json)tuple2._1();
            Json json3 = (Json)tuple2._2();
            if (json instanceof Json.JString) {
                Json.JString jString = (Json.JString)json;
                String a = jString.value();
                if (json3 instanceof Json.JString) {
                    Json.JString jString2 = (Json.JString)json3;
                    String b = jString2.value();
                    String string = a;
                    String string2 = b;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
            }
        }
        if (tuple2 != null) {
            Json json = (Json)tuple2._1();
            Json json4 = (Json)tuple2._2();
            if (json instanceof Json.JNumber) {
                Json.JNumber jNumber = (Json.JNumber)json;
                JsonNumber a = jNumber.value();
                if (json4 instanceof Json.JNumber) {
                    Json.JNumber jNumber2 = (Json.JNumber)json4;
                    JsonNumber b = jNumber2.value();
                    return JsonNumber$.MODULE$.eqJsonNumber().eqv((Object)a, (Object)b);
                }
            }
        }
        if (tuple2 != null) {
            Json json = (Json)tuple2._1();
            Json json5 = (Json)tuple2._2();
            if (json instanceof Json.JBoolean) {
                Json.JBoolean jBoolean = (Json.JBoolean)json;
                boolean a = jBoolean.value();
                if (json5 instanceof Json.JBoolean) {
                    Json.JBoolean jBoolean2 = (Json.JBoolean)json5;
                    boolean b = jBoolean2.value();
                    return a == b;
                }
            }
        }
        if (tuple2 != null) {
            Json json = (Json)tuple2._1();
            Json json6 = (Json)tuple2._2();
            if (json instanceof Json.JArray) {
                Json.JArray jArray = (Json.JArray)json;
                Vector<Json> a = jArray.value();
                if (json6 instanceof Json.JArray) {
                    Json.JArray jArray2 = (Json.JArray)json6;
                    Vector<Json> b = jArray2.value();
                    return MODULE$.arrayEq(a, b);
                }
            }
        }
        if (tuple2 != null) {
            Json x = (Json)tuple2._1();
            Json y = (Json)tuple2._2();
            return x.isNull() && y.isNull();
        }
        throw new MatchError((Object)tuple2);
    }

    private Json$() {
    }
}

